% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwt.R
\name{dwt}
\alias{dwt}
\title{Discrete Wavelet Transform}
\usage{
dwt(x, nlevels = floor(log2(length(x))), filter = "haar",
  boundary = "periodic", bw = TRUE)
}
\arguments{
\item{x}{A \code{vector} with dimensions N x 1.}

\item{nlevels}{A \code{integer} indicating the \eqn{J} levels of decomposition.}

\item{filter}{A \code{string} indicating the filter name}

\item{boundary}{A \code{string} indicating whether the filter is: \code{"periodic"} or \code{"reflection"}.}

\item{bw}{A \code{boolean} indicating whether to remove (TRUE) or keep (FALSE) boundary wavelet coefficients}
}
\value{
y A \code{field<vec>} that contains the wavelet coefficients for each decomposition level
}
\description{
Calculation of the coefficients for the discrete wavelet transformation
}
\details{
Performs a level \eqn{J} decomposition of the time series using the pyramid algorithm.
The default \eqn{J} is determined by \eqn{floor\left(log_2 \left(length\left(x\right)\right)\right)}{floor(log2(length(x)))}
}
\examples{
set.seed(999)
x = rnorm(2^8)
dwt(x)
}
\author{
JJB
}

