% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{deriv_wn}
\alias{deriv_wn}
\title{Analytic D matrix white noise process}
\usage{
deriv_wn(tau)
}
\arguments{
\item{tau}{A \code{vec} that contains the scales to be processed (e.g. 2^(1:J))}
}
\value{
A \code{matrix} with the first column containing the partial derivative with respect to \eqn{\sigma _0^2}{sigma[0]^2}.
}
\description{
Analytic D matrix white noise process
}
\details{
The haar wavelet variance is given as \eqn{{\nu ^2}\left( \tau  \right) = \frac{{\sigma _0^2}}{\tau }}{nu^2(tau) = sigma_0^2 / tau}.
Taking the derivative with respect to \eqn{\sigma _0^2}{sigma_0^2} yields: \eqn{\frac{\partial }{{\partial \sigma _0^2}}{\nu ^2}\left( \tau  \right) = \frac{1}{\tau }}{1/tau}
}
\examples{
deriv_wn(2^(1:5))
}
\author{
JJB
}

