% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts.model.R
\name{GM}
\alias{GM}
\title{Create a Gauss-Markov (GM) Process}
\usage{
GM(beta = NULL, sigma2_gm = 1)
}
\arguments{
\item{beta}{A \code{double} value for the \eqn{\beta}{beta} of an GM process.}

\item{sigma2_gm}{A \code{double} value for the variance, \eqn{\sigma ^2_{gm}}{sigma^2[gm]}, of a WN process.}
}
\value{
An S3 object with called ts.model with the following structure:
\describe{
 \item{process.desc}{Used in summary: "BETA","SIGMA2"}
 \item{theta}{\eqn{\beta}{beta}, \eqn{\sigma ^2_{gm}}{sigma^2[gm]}}
 \item{plength}{Number of Parameters}
 \item{desc}{"GM"}
 \item{obj.desc}{Depth of Parameters e.g. list(1,1)}
 \item{starting}{Guess Starting values? TRUE or FALSE (e.g. specified value)}
}
}
\description{
Setups the necessary backend for the GM process.
}
\details{
When supplying values for \eqn{\beta}{beta} and \eqn{\sigma ^2_{gm}}{sigma^2[gm]},
these parameters should be of a GM process and NOT of an AR1. That is,
do not supply AR1 parameters such as \eqn{\phi}{phi}, \eqn{\sigma^2}{sigma^2}.

Internally, GM parameters are converted to AR1 using the `freq` 
supplied when creating data objects (\link[gmwm]{imu}, \link[gmwm]{gts})
or specifying a `freq` parameter in \link[gmwm]{gmwm} or \link[gmwm]{gmwm.imu}.

The `freq` of a data object takes precedence over the `freq` set when modeling.
}
\examples{
GM()
GM(beta=.32, sigma2_gm=1.3)
}
\author{
JJB
}

