% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dr_to_wv}
\alias{dr_to_wv}
\title{Drift to WV}
\usage{
dr_to_wv(omega, tau)
}
\arguments{
\item{omega}{A \code{double} corresponding to variance of drift}

\item{tau}{A \code{vec} containing the scales e.g. 2^tau}
}
\value{
A \code{vec} containing the wavelet variance of the drift.
}
\description{
This function compute the WV (haar) of a Drift process
}
\examples{
x.sim = 1:1000
ntau = floor(log(length(x.sim),2))
tau = 2^(1:ntau)
wv.theo = dr_to_wv(1, tau)
plot(tau, wv.theo, col = "red")
}

