% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-define.R
\name{md_define}
\alias{md_define}
\title{Markdown definitions}
\usage{
md_define(term, def)
}
\arguments{
\item{term}{A character vector of terms to define.}

\item{def}{A character vector of definitions to be used for each \code{term.}}
}
\value{
A character vector with elements preceded by an asterisk symbol.
}
\description{
Take a character vector of terms and of corresponding definitions and return
a single glue vector of concatenated entries separated by two newlines. This
container is rendered as the \code{<dl>} HTML
}
\details{
Definitions are not supported in GFM, but \emph{are} supported by the
\href{https://pandoc.org/MANUAL.html#pandocs-markdown}{pandoc engine} used by R
Markdown. Per that specification: Each term must fit on one line, which may
optionally be followed by a blank line, and must be followed by one or more
definitions. A definition begins with a colon or tilde, which may be indented
one or two spaces.
}
\examples{
md_define("Democracy", md_italic("Government by the people"))
md_define(state.abb[1:5], state.name[1:5])
}
\seealso{
Other container block functions: \code{\link{md_bullet}},
  \code{\link{md_list}}, \code{\link{md_order}},
  \code{\link{md_quote}}, \code{\link{md_task}}
}
\concept{container block functions}
