% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcPlot.R
\name{fcPlot}
\alias{fcPlot}
\title{Plotly or ggplot fold change plots}
\usage{
fcPlot(
  object,
  x1var,
  x2var,
  x1Values = NULL,
  x2Values = NULL,
  pCutoff = 0.01,
  labels = c(),
  useAdjusted = FALSE,
  plotCutoff = 1,
  graphics = "ggplot",
  fontSize = 12,
  labelFontSize = 4,
  colours = c("grey", "goldenrod1", "red", "blue"),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{A glmmSeq object created by
\code{\link[glmmSeq:glmmSeq]{glmmSeq::glmmSeq()}}.}

\item{x1var}{The name of the first (inner) x parameter}

\item{x2var}{The name of the second (outer) x parameter}

\item{x1Values}{Timepoints or categories in \code{x1var} used to calculate fold
change. If \code{NULL} the first two levels in \code{x1var} are used.}

\item{x2Values}{Categories in \code{x2var} to be compared on x and y axis.}

\item{pCutoff}{The significance cut-off for colour-coding
(default = 0.01)}

\item{labels}{Row names or indices to label on plot}

\item{useAdjusted}{whether to use adjusted p-values (must have q-values in
\code{object}). Default = FALSE}

\item{plotCutoff}{Which probes to include on plot by significance cut-off
(default = 1, for all markers)}

\item{graphics}{Graphics system to use: "ggplot" or "plotly"}

\item{fontSize}{Font size}

\item{labelFontSize}{Font size for labels}

\item{colours}{Vector of colours to use for significance groups}

\item{verbose}{Whether to print statistics}

\item{...}{Other parameters to pass to plotly or ggplot}
}
\value{
Returns a plot for fold change between x1Values in one x2Value
subset on x axis and fold change in the other x2Value on the y axis.
}
\description{
Plotly or ggplot fold change plots
}
\examples{
data(PEAC_minimal_load)

disp <- apply(tpm, 1, function(x) {
(var(x, na.rm = TRUE)-mean(x, na.rm = TRUE))/(mean(x, na.rm = TRUE)**2)
})

glmmFit <- glmmSeq(~ Timepoint * EULAR_6m + (1 | PATID),
                     countdata = tpm[1:5, ],
                     metadata = metadata,
                     dispersion = disp,
                     verbose = FALSE)

fcPlot(object = glmmFit,
      x1var = "Timepoint",
      x2var = "EULAR_6m",
      x2Values = c("Good", "Non-response"),
      pCutoff = 0.05,
      useAdjusted = FALSE,
      plotCutoff = 1,
      graphics = "plotly")
}
\keyword{hplot}
