% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloplot.gllvm.R
\name{phyloplot.gllvm}
\alias{phyloplot.gllvm}
\alias{phyloplot}
\title{Plot phylogenetic random effects from gllvm}
\usage{
\method{phyloplot}{gllvm}(
  object,
  tree,
  comm.eff = TRUE,
  row.eff = FALSE,
  which.Xcoef = NULL,
  xlim = NULL,
  level = 0.95,
  col = c("#E69F00", "white", "#009E73"),
  col.sym = TRUE,
  tick.length = 2,
  mar.spec = c(3, 2, 0, 0),
  mar.phy = c(0, 2, 2, 0),
  mar.comm = c(3, 0.5, 2, 1.5),
  cex = 0.6,
  lwd = 1,
  col.edge = "black",
  pch = "x",
  heights = c(0.55, 0.35),
  widths = c(0.64, 0.1),
  phy.place = "top",
  ...
)
}
\arguments{
\item{object}{an object of class 'gllvm'.}

\item{tree}{an object of class ''}

\item{comm.eff}{logical, defaults to \code{TRUE}. If present in the model, should community effects be plotted?}

\item{row.eff}{logical, defaults to \code{FALSE}. If present in the model, should row effects (e.g., community responses to covariates) be included?}

\item{which.Xcoef}{List of length 2 with names to subset the effects to plot. The first vector is for the species plot, the second for community effects.}

\item{xlim}{vector of length two. Limits for the x-axis of the caterpillar plot. Defaults to NULL, in which case the limits are chosen based on the confidence intervals.}

\item{level}{the confidence level. Scalar between 0 and 1.}

\item{col}{vector of three colors (defaults to \code{c("#E69F00","white","#009E73")}) passed to \code{\link{colorRampPalette}} for species random effects.}

\item{col.sym}{logical, defaults to \code{TRUE}. Then, the color scale of the species random effects plot is symmetrical (so that zero is nearly in the middle), so that both the lower and upper limit are determined by the largest absolute value. If \code{FALSE}, the lower and upper limits are determined by the smallest and largest values, respectively.}

\item{tick.length}{numerical, defaults to 2. Length of ticks for the species-specific random effects plot.}

\item{mar.spec}{vector of length 4, which defines the margins sizes for the species random effects plot. Defaults to \code{c(3, 2, 0, 0)}.}

\item{mar.phy}{vector of length 4, which defines the margins sizes for plotting the phylogeny. Defaults to \code{c(0, 2, 2, 0)}.}

\item{mar.comm}{vector of length 4, which defines the margins sizes for the caterpillar plot. Defaults to \code{c(3, 0.5, 2, 1.5)}.}

\item{cex}{the magnification to be used for text in the plot. Defaults to 0.6.}

\item{lwd}{line thickness for the branches in the phylogeny and the confidence intervals in the caterpillar plot. Defaults to 1.}

\item{col.edge}{character. Color of branches in the phylogeny.}

\item{pch}{symbol used in the catter pillar plot. Defaults to "x".}

\item{heights}{vector of length two. Relative row heights, defaults to \code{c(0.55, 0.35)}.}

\item{widths}{vector of length two. Relative column widths, defaults to \code{c(0.64, 0.10)}.}

\item{phy.place}{not (yet) in use.}

\item{...}{additional not in use.}
}
\description{
Plots phylogenetic random effects with the phylogeny, and community effects
}
\details{
Plots phylogenetically structured random effects together with the phylogeny,
and with community-level effects (i.e., effects that are the same across species).
If standard errors have been calculated for the model, the prediction intervals for
species random effects are checked, and crossed out (i.e., displayed as white) if
they cross zero.
}
\examples{
\dontrun{
# Load dataset
data(fungi)
Y <- fungi$Y
# Scale the predictor
X <- fungi$X
X[,"DBH.CM"] <- scale(X[, "DBH.CM"])
tree <- fungi$tree # the tree
colMat <- fungi$C # e.g., from ape::vcv(tree)
dist <- fungi$dist # e.g., from ape::cophenetic.phylo(tree)
order <- gllvm:::findOrder(covMat = colMat, distMat = dist, nn = 15,
                           order = order(dist[1:length(tree$tip.label), nrow(dist)],
                           decreasing = TRUE))$order
order <- tree$tip.label[order]
model <- gllvm(y = Y[,order], X = X,
                formula = ~(DBH.CM|1), beta0com = TRUE,
                family = "binomial", num.lv = 0, nn.colMat = 15,
                colMat = list(colMat[order,order], dist = dist[order,order]), 
                colMat.rho.struct = "term")
phyloplot(model, tree)
}
}
\references{
van der Veen, B., O'Hara, R.B. (2024). Fast fitting of Fast fitting of phylogenetic mixed effects models. arXiv.
}
\author{
Bert van der Veen
}
