% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadGimms.R
\docType{methods}
\name{downloadGimms}
\alias{downloadGimms}
\alias{downloadGimms,Date-method}
\alias{downloadGimms,character-method}
\alias{downloadGimms,missing-method}
\alias{downloadGimms,numeric-method}
\title{Download GIMMS NDVI3g Data}
\usage{
\S4method{downloadGimms}{Date}(x, y, version = 1L, dsn = getwd(),
  overwrite = FALSE, quiet = TRUE, mode = "wb", cores = 1L, ...)

\S4method{downloadGimms}{numeric}(x, y, version = 1L, dsn = getwd(),
  overwrite = FALSE, quiet = TRUE, mode = "wb", cores = 1L, ...)

\S4method{downloadGimms}{character}(x, dsn = getwd(), overwrite = FALSE,
  quiet = TRUE, mode = "wb", cores = 1L, ...)

\S4method{downloadGimms}{missing}(version = 1L, dsn = getwd(),
  overwrite = FALSE, quiet = TRUE, mode = "wb", cores = 1L, ...)
}
\arguments{
\item{x}{Start time for data download as either \code{Date} object (e.g.,
\code{as.Date("2000-01-01")}) or \code{numeric} year (e.g., \code{2000}).
Alternatively, a \code{character} vector of online filepaths to download
created from \code{\link{updateInventory}}. If \code{missing}, all files
available only are being downloaded.}

\item{y}{End time for data download as either \code{Date} object or
\code{numeric} year. Ignored if 'x' is a \code{character} object or missing.}

\item{version}{\code{integer} (or any other convertible class), defaults to
\code{1L}. Specifies desired GIMMS NDVI3g product version, see 'Details' in
\code{\link{updateInventory}}. Ignored if 'x' is a \code{character} object.}

\item{dsn}{\code{character}, defaults to the current working directory.
Target folder for file download.}

\item{overwrite}{\code{logical}, defaults to \code{FALSE}. If \code{TRUE},
identically named files in 'dsn' will be overwritten.}

\item{quiet}{\code{logical}. If \code{TRUE} (default), console output is
reduced.}

\item{mode}{\code{character}. See \code{\link{download.file}}.}

\item{cores}{\code{integer}, defaults to \code{1L}. Number of cores used for
parallel processing. Note that a fast internet connection is required in
order for parallelization to take effect.}

\item{...}{Further arguments passed to \code{\link{download.file}}, e.g.
'method'.}
}
\value{
A \code{character} vector of local filepaths.
}
\description{
Download GIMMS NDVI3g data from the NASA Ames Ecological Forecasting Lab,
optionally for a given period of time. Both NDVI3g.v1 (NetCDF, until end
2015) and NDVI3g.v0 (ENVI binary, until end 2013) are available.
}
\examples{
\dontrun{
## 'Date' method
gimms_files_date <- downloadGimms(x = as.Date("2000-01-01"),
                                  y = as.Date("2000-12-31"))

## 'numeric' method (i.e., particular years)
gimms_files_year <- downloadGimms(x = 2000,
                                  y = 2002)

## 'character' method (i.e., particular files)
gimms_files_char <- updateInventory()
gimms_files_char <- downloadGimms(x = gimms_files[1:6])

## 'missing' method (i.e., entire collection)
gimms_files_full <- downloadGimms()
}

}
\seealso{
\code{\link{updateInventory}}, \code{\link{download.file}}.
}

