\name{aggregate}
\alias{aggregate}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Group-level structural equation model search.
}
\description{
Concatenates all individual-level data files and fits a group model to the data.
}
\usage{
aggregate(data = "", 
          sep = "", 
          header = , 
          out = "",
          ar = FALSE, 
          plot = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{
Path to the directory where the data files are located. Each file must contain one matrix for each individual containing a T (time) by p (number of variables) matrix where the columns represent variables and the rows represent time.
}
  \item{sep}{
The spacing of the data files. "" indicates space-delimited, "/t" indicates tab-delimited, "," indicates comma delimited.
}
  \item{header}{
Logical. Indicate TRUE for data files with a header.
}
  \item{out}{
The path to the directory where the results will be stored. This directory must be generated by the user prior to running the function.
}
  \item{ar}{
Logical. If TRUE, begins search for group model with autoregressive (AR) paths open. Defaults to FALSE.
}
  \item{plot}{
Logical. If TRUE, graphs depicting relations among variables of interest will automatically be created. Defaults to TRUE.
}
}
\value{
\item{all.elements}{Contains estimate, standard error, and p value for estimated paths.}
\item{all.fit}{Contains model fit information for group-level model.}
}
\author{
Stephanie Lane
}
\examples{
data(ts1,ts2,ts3,ts4,ts5)
input.path <- paste(file.path(tempdir()),"/input",sep="")
dir.create(input.path)
output.path <- paste(file.path(tempdir()),"/output",sep="")
dir.create(output.path)
write.table(ts1,paste(input.path,"/ts1.txt",sep=""),col.names=FALSE,row.names=FALSE)
write.table(ts2,paste(input.path,"/ts2.txt",sep=""),col.names=FALSE,row.names=FALSE)
write.table(ts3,paste(input.path,"/ts3.txt",sep=""),col.names=FALSE,row.names=FALSE)
write.table(ts4,paste(input.path,"/ts4.txt",sep=""),col.names=FALSE,row.names=FALSE)
write.table(ts5,paste(input.path,"/ts5.txt",sep=""),col.names=FALSE,row.names=FALSE)
aggregate.out <- aggregate(data = input.path,
                 sep = "",
                 header = FALSE,
                 out = output.path,
                 ar = TRUE,
                 plot = TRUE)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{aggregate}

