% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_giedata.R
\name{get_giedata}
\alias{get_giedata}
\title{get_giedata}
\usage{
get_giedata(
  country,
  company = NULL,
  facility = NULL,
  from = NULL,
  to = NULL,
  date = NULL,
  size = 30,
  timeout = 3,
  database = "agsi",
  verbose = FALSE,
  apikey = Sys.getenv("GIE_APIKEY")
)
}
\arguments{
\item{country}{Character. Specify the country of interest as two-digit country code (e.g., 'DE', 'IE').}

\item{company}{Character. EIC code for the requested company.}

\item{facility}{Character. EIC code for the requested facility.}

\item{from}{Character. Specify the start of the time span you are \cr
interested in downloading (format: YYYY-MM-DD).}

\item{to}{Character. Specify the end of the time span you are \cr
interested in downloading (format: YYYY-MM-DD).}

\item{date}{Character. If you want to have data only for one date. \cr
If you set 'date', you cannot set the 'from' and/or 'to' parameters \cr
(format: YYYY-MM-DD).}

\item{size}{Integer. The number of results per page.}

\item{timeout}{Numeric. If the amount of pages of your request exceeds 60, a timeout \cr
will be enforced to prevent the API from timing out. Defaults to 3 seconds, any \cr
values must be set in seconds, too.}

\item{database}{Character. The type of API you want to address ('agsi' or 'alsi').}

\item{verbose}{Logical. Prints information on function progress to the console (default: FALSE).}

\item{apikey}{Character. Your personal API key.}
}
\value{
A data.frame or list with the results.
}
\description{
Function to download data from GIE's AGSI+ API
}
\examples{
\dontrun{
get_giedata(country = "DE", date = "2022-01-03")
}
}
