% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nrmSelection.R, R/print.R
\name{nrm_selection}
\alias{nrm_selection}
\alias{nrm_selection.default}
\alias{nrm_selection.nrmpredictor}
\alias{print.nrm_selection}
\title{Perform AIC forward selection for nrm.}
\usage{
nrm_selection(
  adj,
  predictors,
  directed,
  selfloops,
  pval = 0.05,
  xi = NULL,
  init = NULL,
  ncores = NULL,
  ...
)

\method{nrm_selection}{default}(
  adj,
  predictors,
  directed,
  selfloops,
  pval = 0.05,
  xi = NULL,
  init = NULL,
  ncores = NULL,
  ...
)

\method{nrm_selection}{nrmpredictor}(
  adj,
  predictors,
  directed,
  selfloops,
  pval = 0.05,
  xi = NULL,
  init = NULL,
  ncores = NULL,
  ...
)

\method{print}{nrm_selection}(x, ...)
}
\arguments{
\item{adj}{the adjacency matrix of the response network}

\item{predictors}{list containing the set of predictors as sublists.}

\item{directed}{logical, is the response network directed?}

\item{selfloops}{logical, do the response network allows selfloops?}

\item{pval}{the significance at which computing confidence intervals.}

\item{xi}{optional, the possibility matrix \eqn{\Xi}.}

\item{init}{optional, initial values passed to the solver to estimate the MLE.}

\item{ncores}{optional, number of cores over which parallelise the task.}

\item{\dots}{optional arguments to print or plot methods.}

\item{x}{object of class \code{'nrm_selection'}.}
}
\value{
A nrm object
}
\description{
Perform AIC forward selection for nrm.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method for the nrm stepwise selection.

\item \code{nrmpredictor}: Method for the nrm stepwise selection when nrmpredictors are passed.

\item \code{nrm_selection}: Print method for elements of class \code{'nrm_selection'}.
}}

\examples{
\donttest{
data('highschool.predictors')
nrm_selection(adj=contacts.adj,predictors=createPredictors(highschool.predictors),
  ncores=1,directed=FALSE,selfloops=FALSE)
 }
}
\seealso{
\code{\link{nrm}}

\code{nrm_selection}
}
\author{
Giona Casiraghi

Giona Casiraghi
}
