% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/org.R, R/org_admins.R, R/org_invite.R,
%   R/org_members.R, R/org_pending.R, R/org_remove.R
\name{org_members}
\alias{org_members}
\alias{org_admins}
\alias{org_invite}
\alias{org_pending}
\alias{org_remove}
\title{Tools for managing organization membership}
\usage{
org_admins(org)

org_invite(org, user)

org_members(org, filter = NULL, exclude = FALSE, include_admins = TRUE)

org_pending(org, filter = NULL, exclude = FALSE)

org_remove(org, user, prompt = TRUE)
}
\arguments{
\item{org}{Character. Name of the GitHub organization(s).}

\item{user}{Character. GitHub username(s).}

\item{filter}{Character. Regular expression pattern for matching (or excluding) results}

\item{exclude}{Logical. Should entries matching the regular expression be excluded or included.}

\item{include_admins}{Logical. Should admin users be included in the results.}

\item{prompt}{Logical. Prompt before removing member from organization.}
}
\value{
\code{org_members()}, \code{org_pending()}, and \code{org_admins} all return a character vector
of GitHub account names.

\code{org_invite()} and \code{org_remove()} invisibly return a list containing the results of the relevant GitHub API calls.
}
\description{
\itemize{
\item \code{org_invite()} - invites user(s) to a GitHub organization.
\item \code{org_remove()} - remove user(s) from an organization (and all teams within that organization).
\item \code{org_members()} - returns a (filtered) vector of organization members.
\item \code{org_pending}() - returns a (filtered) vector of pending organization members.
\item \code{org_admins()} - returns a vector of repository administrators. In the case of a
non-organization owner (e.g. a user account) returns the owner's login.
}
}
\examples{
\dontrun{
# Org Details
org_admins("ghclass-test")

org_admins("rundel") # User, not an organization


# Org Membership - Invite, Status, and Remove
students = c("ghclass-anya", "ghclass-bruno", "ghclass-celine",
             "ghclass-diego", "ghclass-elijah","ghclass-francis")

org_invite("ghclass-test", students)

org_members("ghclass-test")

org_pending("ghclass-test")

org_remove("ghclass-test", students, prompt = FALSE)

org_pending("ghclass-test")
}

}
