% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{scale_ordinal}
\alias{scale_logical}
\alias{scale_nominal}
\alias{scale_ordinal}
\title{Add a ordinal, nominal, or logical scale to a ggvis object.}
\usage{
scale_ordinal(vis, property, domain = NULL, range = NULL, reverse = NULL,
  round = NULL, points = NULL, padding = NULL, sort = NULL,
  name = property, label = NULL, override = NULL)

scale_nominal(vis, property, domain = NULL, range = NULL, reverse = NULL,
  round = NULL, points = NULL, padding = NULL, sort = NULL,
  name = property, label = NULL, override = NULL)

scale_logical(vis, property, domain = NULL, range = NULL, reverse = NULL,
  round = NULL, points = NULL, padding = NULL, sort = NULL,
  name = property, label = NULL, override = NULL)
}
\arguments{
\item{vis}{A ggvis object.}

\item{property}{The name of a property, such as "x", "y", "fill", "stroke", etc.}

\item{domain}{The domain of the scale, representing the set of data values.
For ordinal scales, a character vector; for quantitative scales, a numeric
vector of length two. Either value (but not both) may be NA, in which
case \code{domainMin} or \code{domainMax} is set. For dynamic scales, this
can also be a reactive which returns the appropriate type of vector.}

\item{range}{The range of the scale, representing the set of visual values.
For numeric values, the range can take the form of a two-element array with
minimum and maximum values. For ordinal data, the range may by an array of
desired output values, which are mapped to elements in the specified
domain. The following range literals are also available: "width", "height",
"shapes", "category10", "category20".}

\item{reverse}{If true, flips the scale range.}

\item{round}{If true, rounds numeric output values to integers. This can be
helpful for snapping to the pixel grid.}

\item{points}{If \code{TRUE} (default), distributes the ordinal values over a
quantitative range at uniformly spaced points. The spacing of the points
can be adjusted using the padding property. If \code{FALSE}, the ordinal
scale will construct evenly-spaced bands, rather than points. Note that
if any mark is added with a \code{\link{band}()} prop, then the scale for
that prop will automatically have \code{points} set to \code{FALSE}.}

\item{padding}{Applies spacing among ordinal elements in the scale range.
The actual effect depends on how the scale is configured. If the points
parameter is true, the padding value is interpreted as a multiple of the
spacing between points. A reasonable value is 1.0, such that the first and
last point will be offset from the minimum and maximum value by half the
distance between points. Otherwise, padding is typically in the range
[0, 1] and corresponds to the fraction of space in the range interval to
allocate to padding. A value of 0.5 means that the range band width will
be equal to the padding width. For positional (x and y) scales, the default
padding is 0.1. For other scales, the default padding is 0.5.}

\item{sort}{If \code{TRUE}, the values in the scale domain will be sorted
according to their natural order. Default is \code{FALSE}.}

\item{name}{Name of the scale, such as "x", "y", "fill", etc. Can also be an
arbitrary name like "foo".}

\item{label}{Label for the scale. Used for axis or legend titles.}

\item{override}{Should the domain specified by this ggvis_scale object
override other ggvis_scale objects for the same scale? Useful when domain is
manually specified. For example, by default, the domain of the scale
will contain the range of the data, but when this is TRUE, the specified
domain will override, and the domain can be smaller than the range of the
data. If \code{FALSE}, the \code{domain} will not behave this way. If
left \code{NULL}, then it will be treated as \code{TRUE} whenever
\code{domain} is non-NULL.}
}
\description{
Ordinal, nominal, and logical scales are all categorical, and are treated
similarly by ggvis.
}
\examples{
p <- PlantGrowth \%>\% ggvis(~group, ~weight) \%>\% layer_points()

p
p \%>\% scale_nominal("x", padding = 0)
p \%>\% scale_nominal("x", padding = 1)

p \%>\% scale_nominal("x", reverse = TRUE)

p <- ToothGrowth \%>\% group_by(supp) \%>\%
  ggvis(~len, fill = ~supp) \%>\%
  layer_histograms(width = 4, stack = TRUE)

# Control range of fill scale
p \%>\% scale_nominal("fill", range = c("pink", "lightblue"))

# There's no default range when the data is categorical but the output range
# is continuous, as in the case of opacity. In these cases, you can
# manually specify the range for the scale.
mtcars \%>\% ggvis(x = ~wt, y = ~mpg, opacity = ~factor(cyl)) \%>\%
  layer_points() \%>\%
  scale_nominal("opacity", range = c(0.2, 1))
}
\seealso{
\code{\link{scales}}, \code{\link{scale_numeric}},
  \url{https://github.com/trifacta/vega/wiki/Scales#ordinal-scale-properties},
  \url{https://github.com/mbostock/d3/wiki/Ordinal-Scales}

Other scales: \code{\link{scale_datetime}},
  \code{\link{scale_numeric}}
}

