% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/input.R
\name{create_input}
\alias{create_input}
\title{Create a new interactive "input" object.}
\usage{
create_input(id = rand_id("input_"), default = NULL, map = identity,
  controls = NULL)
}
\arguments{
\item{id}{The name of the input object in the Shiny app, such as
"slider_1338869".}

\item{default}{The default (starting) value for the input.}

\item{map}{A mapping function. Defaults to \code{identity}, which simply
returns the value unchanged.}

\item{controls}{A Shiny HTML tag object representing the UI for the controls.}
}
\description{
An interactive input object is a reactive expression which wraps a reactive
value. When the plot is rendered, an observer is created which pushes values
into the reactive value in response to changes of an input object. Those
changes invalidate the reactive expression, which will return the value,
optionally passed through a mapping function.
}
\details{
This function is designed to be used by authors of new types of interactive
inputs. If you are a ggvis user, please use one of the more specific input
functions starting with the \code{input_}.
}
\keyword{internal}

