% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-wb-box.R
\name{stat_wb_box}
\alias{stat_wb_box}
\title{Draw colour boxes for wavebands}
\usage{
stat_wb_box(
  mapping = NULL,
  data = NULL,
  geom = "rect",
  w.band = NULL,
  ypos.mult = 1.07,
  ypos.fixed = NULL,
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{w.band}{a waveband object or a list of waveband objects or numeric
vector of at least length two.}

\item{ypos.mult}{numeric Multiplier constant used to scale returned
\code{y} values.}

\item{ypos.fixed}{numeric If not \code{NULL} used a constant value returned
in \code{y}.}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{na.rm}{a logical value indicating whether NA values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\value{
A data frame with one row for each waveband object in the argument
to \code{w.band}. Wavebeand outside the range of the spectral data are
trimmed or discarded.
}
\description{
\code{stat_wb_box} plots boxes corresponding to wavebands, by default located
slightly above the peak of the spectrum. Sets suitable default aesthetics for
"rect" geom.
}
\note{
This stat uses a panel function and ignores grouping as it is meant to
  be used for annotations.The value returned as default value for \code{y} is
  based on the y-range of spectral values for the whole data set.
}
\section{Computed variables}{

What it is named integral below is the result of appying \code{integral.fun}
to the data, with default \code{integrate_xy}.
\describe{
  \item{x}{w.band-midpoint}
  \item{wb.xmin}{w.band minimum}
  \item{wb.xmax}{w.band maximum}
  \item{wb.ymin}{data$y minimum}
  \item{wb.ymax}{data$y maximum}
  \item{y}{ypos.fixed or top of data, adjusted by \code{ypos.mult}}
  \item{wb.color}{color of the w.band}
  \item{wb.name}{label of w.band}
  \item{BW.color}{\code{black_or_white(wb.color)}}
}
}

\section{Default aesthetics}{

Set by the statistic and available to geoms.
\describe{
  \item{xmin}{..wb.xmin..}
  \item{xmax}{..wb.xmax..}
  \item{ymin}{..y.. - (..wb.ymax.. - ..wb.ymin..) * 0.03}
  \item{ymax}{..y.. + (..wb.ymax.. - ..wb.ymin..) * 0.03}
  \item{fill}{..wb.color..}
}
}

\section{Required aesthetics}{

Required by the statistic and need to be set with \code{aes()}.
\describe{
  \item{x}{numeric, wavelength in nanometres}
  \item{y}{numeric, a spectral quantity}
}
}

\examples{

library(photobiologyWavebands)
# ggplot() methods for spectral objects set a default mapping for x and y.
ggplot(sun.spct) +
  stat_wb_box(w.band = VIS_bands()) +
  geom_line() +
  scale_fill_identity()
ggplot(sun.spct) +
  stat_wb_box(w.band = VIS_bands(), color = "white") +
  geom_line() +
  scale_fill_identity()

}
\seealso{
Other stats functions: 
\code{\link{stat_color}()},
\code{\link{stat_find_qtys}()},
\code{\link{stat_find_wls}()},
\code{\link{stat_label_peaks}()},
\code{\link{stat_peaks}()},
\code{\link{stat_wb_column}()},
\code{\link{stat_wb_contribution}()},
\code{\link{stat_wb_hbar}()},
\code{\link{stat_wb_irrad}()},
\code{\link{stat_wb_label}()},
\code{\link{stat_wb_mean}()},
\code{\link{stat_wb_relative}()},
\code{\link{stat_wb_sirrad}()},
\code{\link{stat_wb_total}()},
\code{\link{stat_wl_strip}()},
\code{\link{stat_wl_summary}()}
}
\concept{stats functions}
