% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.generic_spct}
\alias{plot.generic_spct}
\alias{plot.generic_mspct}
\alias{plot.waveband}
\title{Create a complete ggplot for a spectrum.}
\usage{
\method{plot}{generic_spct}(x, ...)

\method{plot}{generic_mspct}(x, ...)

\method{plot}{waveband}(x, ...)
}
\arguments{
\item{x}{An R object derived from class \code{generic_spct} or derived
from class \code{generic_mspct}.}

\item{...}{Named arguments passed to \code{plot()} methods.}
}
\value{
a \code{ggplot} object.
}
\description{
This method returns a ggplot object with an annotated plot of an object of a
class derived from \code{generic_spct} or of a class derived from
\code{generic_mspct} for which a \code{plot()} method exists. It is implemented
as a wrapper of \code{autoplot()}. This function is available for backwards
compatibility, but new code should call this same function using
method \code{autoplot()} instead.
}
\details{
Support for \code{autoplot()} method for consistency
  with package 'ggplot2'. Please consult the documentation of the
  \code{plot()} methods for details about use of these autoplot methods.
  They are implemented as simple wrappers that forward the call to
  \code{plot()}.
}
\note{
The generic for this method is defined in package 'ggplot2' and
  specializations for objects of diverse classes are provided by 'ggplot2'
  and other packages.
}
\examples{

plot(sun.spct, annotations = "") # deprecated syntax
autoplot(sun.spct, annotations = "") # preferred syntax

}
\seealso{
\code{\link{autoplot.calibration_spct}},  \code{\link{autoplot.cps_spct}},
 \code{\link{autoplot.filter_spct}}, \code{\link{autoplot.raw_spct}},
  \code{\link{autoplot.response_spct}},  \code{\link{autoplot.source_spct}} and
   \code{\link{autoplot.waveband}}.
}
\concept{autoplot functions}
