% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-options.R
\name{set_annotations_default}
\alias{set_annotations_default}
\alias{set_w.band_default}
\alias{set_markup_format_default}
\alias{set_plot_range_default}
\alias{set_pc_out_default}
\alias{set_axis_symbols_default}
\title{Set defaults for plotting}
\usage{
set_annotations_default(annotations = NULL)

set_w.band_default(w.band = NULL)

set_markup_format_default(markup.format = NULL)

set_plot_range_default(range = NULL)

set_pc_out_default(pc.out = TRUE)

set_axis_symbols_default(axis.symbols = TRUE)
}
\arguments{
\item{annotations}{a character vector. For details please see sections Plot
\strong{Annotations} and \strong{Title Annotations}.}

\item{w.band}{a single waveband object or a list of waveband objects.}

\item{markup.format}{character string, "R", "R.expression", "r.character", or
"LaTeX".}

\item{range}{an R object on which \code{range()} returns a vector of length
2, with minimum and maximum wavelengths (nm).}

\item{pc.out}{logical, if \code{TRUE} use percent instead of fraction of one
for normalized spectral data.}

\item{axis.symbols}{logical If \code{TRUE} symbols of the quantities are
added to the default \code{name}.}
}
\value{
Previous value of the option, returned invisibly. This is a named
  list of length one as returned by \code{options}, that can be passed
  unchanged as argument to R function \code{options} or in a new call to the
  same function that returned it.
}
\description{
Set R options controlling default arguments for some formal
  parameters in methods and functions from package 'ggspectra'.
}
\details{
The values accepted, syntax used and behaviour are the same as when passing
arguments to formal parameters in function and methods calls, except that
\code{NULL} as argument clears the R option. To restore the previous state
of an option, save the value returned and pass it as argument in a later
call to the same function.

Changing the defaults with options, instead of affecting a single function
call (e.g., affecting a single plot or layer in a plot), changes the default
used for all subsequent function calls calls when when no argument is passed
explicitly. This makes it possible to easily change in one place in a script
the appearance of all/multiple plots. Using these functions functions instead
of \code{\link{options}} to set the defaults adds a validation step that
protects from errors triggered in subsequent function calls.

R option \code{photobiology.plot.annotations} controls the default for formal
parameter \code{annotations} in \code{autoplot} methods and in
function \code{decoration}.

R option \code{photobiology.plot.bands} controls the default for formal
parameter \code{w.band} in \code{autoplot} methods and in
function \code{decoration}.

R option \code{photobiology.math} controls the default for
formal parameter \code{markup.format} or \code{format} in
different \emph{axis label} and \emph{scale} functions.

R option \code{ggspectra.wlrange} controls the default for
formal parameter \code{range} in \code{autoplot} methods.

R option \code{ggspectra.pc.out} controls the default for
formal parameter \code{pc.out} in \code{autoplot} methods that
have this formal parameter.

R option \code{ggspectra.axis.symbols} controls the default for
formal parameter \code{axis.symbols} in
different \emph{axis label} and \emph{scale} functions.
}
\section{Plot Annotations}{
 The recognized annotation names are: \code{"summaries"}, \code{"peaks"},
  \code{"peak.labels"}, \code{"valleys"}, \code{"valley.labels"},
  \code{"wls"}, \code{"wls.labels"}, \code{"colour.guide"},
  \code{"color.guide"}, \code{"boxes"}, \code{"segments"}, \code{"labels"}.
  In addition, \code{"+"} is interpreted as a request to add to the already
  present default annotations, \code{"-"} as request to remove annotations
  and \code{"="} or missing\code{"+"} and \code{"-"} as a request to reset
  annotations to those requested. If used, \code{"+"}, \code{"-"} or
  \code{"="} must be the first member of a character vector, and followed by
  one or more of the names given above. To simultaneously add and remove
  annotations one can pass a \code{list} containing \code{character} vectors
  each assembled as described. The vectors are applied in the order they
  appear in the list. To disable all annotations pass \code{""} or
  \code{c("=", "")} as argument. Adding a variation of an annotation already
  present, replaces the existing one automatically: e.g., adding
  \code{"peak.labels"} replaces\code{"peaks"} if present.

  The annotation layers are added to the plot using statistics defined in 'ggspectra':
  \code{\link{stat_peaks}}, \code{\link{stat_valleys}},
  \code{\link{stat_label_peaks}}, \code{\link{stat_label_valleys}},
  \code{\link{stat_find_wls}}, \code{\link{stat_spikes}},
  \code{\link{stat_wb_total}}, \code{\link{stat_wb_mean}},
  \code{\link{stat_wb_irrad}}, \code{\link{stat_wb_sirrad}},
  \code{\link{stat_wb_contribution}}, \code{\link{stat_wb_relative}},
  and \code{\link{stat_wl_strip}}. However, only some of their parameters
  can be passed arguments through \code{autoplot} methods. In some cases
  the defaults used by \code{autoplot} methods are not the defaults of the
  statistics.
}

\section{Title Annotations}{
 metadata retrieved from object \code{object} is
  paased to \code{ggplot2::ggtitle()} as arguments for \code{title},
  \code{subtitle} and \code{caption}. The specification for the title is
  passed as argument to \code{annotations}, and consists in the keyword
  \code{title} with optional modifiers selecting the kind of metatdata to
  use, separated by colons. Up to three keywords separated by colons are
  accepted, and correspond to title, subtitle and caption. The recognized
  keywords are: \code{"objt"}, \code{"class"}, \code{"what"}, \code{"when"},
  \code{"where"}, \code{"how"}, \code{"inst.name"}, \code{"inst.sn"},
  \code{"comment"} and \code{"none"} are recognized as modifiers to
  \code{"title"}; \code{"none"} is a placeholder. Default is
  \code{"title:objt"} or no title depending on the context.
}

\seealso{
Additional argument defaults are controlled by options also used in
package 'photobiology'. See \code{\link[photobiology]{energy_as_default}},
  \code{\link[photobiology]{using_Tfr}} and \code{\link{options}}.
}
\concept{set and unset R options}
