% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales-sides-.R
\name{ggside-scales-binned}
\alias{ggside-scales-binned}
\alias{scale_xsidey_binned}
\alias{scale_ysidex_binned}
\title{Position scales for binning continuous data ggside scales}
\usage{
scale_xsidey_binned(
  name = waiver(),
  n.breaks = 10,
  nice.breaks = TRUE,
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  expand = waiver(),
  oob = squish,
  na.value = NA_real_,
  right = TRUE,
  show.limits = FALSE,
  transform = "identity",
  guide = waiver(),
  position = "left"
)

scale_ysidex_binned(
  name = waiver(),
  n.breaks = 10,
  nice.breaks = TRUE,
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  expand = waiver(),
  oob = squish,
  na.value = NA_real_,
  right = TRUE,
  show.limits = FALSE,
  transform = "identity",
  guide = waiver(),
  position = "bottom"
)
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{n.breaks}{The number of break points to create if breaks are not given
directly.}

\item{nice.breaks}{Logical. Should breaks be attempted placed at nice values
instead of exactly evenly spaced between the limits. If \code{TRUE} (default)
the scale will ask the transformation object to create breaks, and this
may result in a different number of breaks than requested. Ignored if
breaks are given explicitly.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
\link[scales:new_transform]{transformation object}
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output (e.g., a function returned by \code{\link[scales:breaks_extended]{scales::extended_breaks()}}).
Note that for position scales, limits are provided after scale expansion.
Also accepts rlang \link[rlang:as_function]{lambda} function notation.
}}

\item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}

\item{limits}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
Note that setting limits on positional scales will \strong{remove} data outside of the limits.
If the purpose is to zoom, use the limit argument in the coordinate system
(see \code{\link[ggplot2:coord_cartesian]{coord_cartesian()}}).
}}

\item{expand}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}

\item{oob}{One of:
\itemize{
\item Function that handles limits outside of the scale limits
(out of bounds). Also accepts rlang \link[rlang:as_function]{lambda}
function notation.
\item The default (\code{\link[scales:oob]{scales::squish()}}) squishes out of
bounds values into range.
\item \link[scales:oob]{scales::censor} for replacing out of bounds values with \code{NA}.
\item \code{\link[scales:oob]{scales::squish_infinite()}} for squishing infinite values into range.
}}

\item{na.value}{Missing values will be replaced with this value.}

\item{right}{Should the intervals be closed on the right (\code{TRUE}, default) or
should the intervals be closed on the left (\code{FALSE})? 'Closed on the right'
means that values at break positions are part of the lower bin (open on the
left), whereas they are part of the upper bin when intervals are closed on
the left (open on the right).}

\item{show.limits}{should the limits of the scale appear as ticks}

\item{transform}{For continuous scales, the name of a transformation object
or the object itself. Built-in transformations include "asn", "atanh",
"boxcox", "date", "exp", "hms", "identity", "log", "log10", "log1p", "log2",
"logit", "modulus", "probability", "probit", "pseudo_log", "reciprocal",
"reverse", "sqrt" and "time".

A transformation object bundles together a transform, its inverse,
and methods for generating breaks and labels. Transformation objects
are defined in the scales package, and are called \verb{transform_<name>}. If
transformations require arguments, you can call them from the scales
package, e.g. \code{\link[scales:transform_boxcox]{scales::transform_boxcox(p = 2)}}.
You can create your own transformation with \code{\link[scales:new_transform]{scales::new_transform()}}.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}

\item{position}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}
}
\value{
ggside_scale object inheriting from ggplot2::ScaleBinnedPosition
}
\description{
The \link{xside} and \link{yside} variants of \link[ggplot2]{scale_x_binned}/\link[ggplot2]{scale_y_binned}.
\link{scale_xsidey_binned} enables better control on how the y-axis is rendered on the xside panel and
\link{scale_ysidex_binned} enables better control on how the x-axis is rendered on the yside panel.
}
\examples{

ggplot(iris, aes(Sepal.Width, Sepal.Length)) +
  geom_point() + geom_xsidepoint(aes(y = Petal.Width, xcolour = Petal.Length)) +
  scale_xsidey_binned(n.breaks = 4) +
  scale_colour_steps(aesthetics ="xcolour", guide = guide_colorbar(available_aes = "xcolour")) +
  theme(ggside.panel.scale.x = .3)

}
