% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabAinv.R
\name{tabAinv}
\alias{tabAinv}
\title{Inverse of the relationship matrix \strong{A} in a tabular format}
\usage{
tabAinv(ped, inbr)
}
\arguments{
\item{ped}{: \code{data.frame} with integer columns corresponding to ID, SIRE, DAM. Missing value is 0.}

\item{inbr}{: Inbreeding coefficients in the order of animals in the relationship matrix.}
}
\value{
Inverse of the genetic relationship \code{data.frame}
}
\description{
Creates the inverse of the pedigree-based additive genetic relationship matrix in a \code{data.frame}.
}
\examples{
ped = data.frame(ID=1:6, SIRE=c(0,0,1,3,1,4), DAM=c(0,0,2,2,2,5))
inbr = c(0, 0, 0, 0.25, 0, 0.25)
# or
(inbr = diag(buildA(ped)) - 1)
# or
inbr = tabA(ped); (inbr = inbr[inbr[,1]==inbr[,2],]$a - 1)
# or
# For individual inbreeding values, use function inb.
tabAinv(ped, inbr)

}
