% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{theme_ridges}
\alias{theme_ridges}
\title{A custom theme specifically for use with ridgeline plots}
\usage{
theme_ridges(font_size = 14, font_family = "", line_size = 0.5,
  grid = TRUE, center_axis_labels = FALSE)
}
\arguments{
\item{font_size}{Overall font size. Default is 14.}

\item{font_family}{Default font family.}

\item{line_size}{Default line size.}

\item{grid}{If \code{TRUE} (default), a background grid is drawn. If \code{FALSE}, background is left empty.}

\item{center_axis_labels}{If \code{TRUE}, axis lables are drawn centered. If \code{FALSE} (default), axis lables are
drawn right/top-aligned.}
}
\value{
The theme.
}
\description{
This theme has some special modifications that make ridgeline plots look better, such as properly aligned y axis labels.
It can draw plots with and without background grids (see examples).
}
\examples{
# Example with background grid
ggplot(iris, aes(x = Sepal.Length, y = Species, group = Species)) +
  geom_density_ridges(rel_min_height = 0.005) +
  scale_y_discrete(expand = c(0.01, 0)) +
  scale_x_continuous(expand = c(0.01, 0)) +
  theme_ridges()

# Example without background grid
ggplot(iris, aes(x = Sepal.Length, y = Species, group = Species)) +
  geom_density_ridges() +
  scale_y_discrete(expand = c(0.01, 0)) +
  scale_x_continuous(expand = c(0.01, 0)) +
  theme_ridges(grid = FALSE)

}
