% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggkm.R
\name{stat_kmband}
\alias{stat_kmband}
\title{Adds confidence bands to a Kaplan Meier Estimate of Survival}
\usage{
stat_kmband(
  mapping = NULL,
  data = NULL,
  geom = "kmband",
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  trans = "identity",
  firstx = 0,
  firsty = 1,
  type = "kaplan-meier",
  error = "greenwood",
  conf.type = "log",
  conf.lower = "usual",
  start.time = 0,
  conf.int = 0.95,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{trans}{Transformation to apply to the survival probabilities. Defaults
to "identity". Other options include "event", "cumhaz", "cloglog", or
define your own using \link{trans_new}.}

\item{firstx, firsty}{the starting point for the survival curves. By default,
the plot program obeys tradition by having the plot start at (0,1).}

\item{type}{an older argument that combined stype and ctype, now deprecated. Legal values were
"kaplan-meier" which is equivalent to stype=1, ctype=1,
"fleming-harrington" which is equivalent to stype=2, ctype=1, and
"fh2" which is equivalent to stype=2, ctype=2.}

\item{error}{either the string "greenwood" for the Greenwood formula or "tsiatis" for the Tsiatis formula,
(only the first character is necessary). The default is "greenwood".}

\item{conf.type}{One of "none", "plain", "log" (the default), "log-log" or "logit".}

\item{conf.lower}{a character string to specify modified lower limits to the curve,
 the upper limit remains unchanged. Possible values are
  "usual" (unmodified),
  "peto", and
  "modified".
The modified lower limit is based on an "effective n" argument.
The confidence bands will agree with the usual calculation at each death time,
but unlike the usual bands the confidence interval becomes wider at each censored observation.
The extra width is obtained by multiplying the usual variance by a factor m/n,
where n is the number currently at risk and m is the number at risk at the last death time.
(The bands thus agree with the un-modified bands at each death time.)
This is especially useful for survival curves with a long flat tail.
The Peto lower limit is based on the same "effective n" argument as the modified limit,
 but also replaces the usual Greenwood variance term with a simple approximation.
 It is known to be conservative.}

\item{start.time}{numeric value specifying a time to start calculating survival information.
The resulting curve is the survival conditional on surviving to start.time.}

\item{conf.int}{the level for a two-sided confidence interval on the survival curve(s). Default is 0.95.}

\item{...}{Other arguments passed to \link[survival]{survfit.formula}}
}
\value{
a data.frame with additional columns: \item{x}{x in data}
  \item{ymin}{Lower confidence
  limit of KM curve} \item{ymax}{Upper confidence limit
  of KM curve}
}
\description{
Adds confidence bands to a Kaplan Meier Estimate of Survival
}
\details{
This stat is for computing the confidence intervals for the Kaplan-Meier survival estimate for
right-censored data. It requires the aesthetic mapping \code{x} for the
observation times and \code{status} which indicates the event status,
0=alive, 1=dead or 1/2 (2=death). Logical status is not supported.
}
\section{Aesthetics}{

\code{stat_kmband} understands the following aesthetics (required aesthetics
are in bold):
\itemize{
  \item \strong{\code{time}} The survival times
  \item \strong{\code{status}} The censoring indicator, see \link[survival]{Surv} for more information.
  \item \code{alpha}
  \item \code{color}
  \item \code{linetype}
  \item \code{size}
}
}

\examples{
library(ggplot2)
sex <- rbinom(250, 1, .5)
df <- data.frame(time = exp(rnorm(250, mean = sex)), status = rbinom(250, 1, .75), sex = sex)
ggplot(df, aes(time = time, status = status, color = factor(sex))) +
 stat_km()

## Examples illustrating the options passed to survfit.formula

p1 <- ggplot(df, aes(time = time, status = status))
p1 + stat_km() + stat_kmband(conf.int = .99)
p1 + stat_kmband(error = "greenwood",fill="red",alpha=0.2) +
 stat_kmband(error = "tsiatis",fill="blue",alpha=0.2)+ stat_km()
p1 + stat_km() + stat_kmband(conf.type = "log-log")+ stat_kmband(conf.type = "log")

}
