% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-poly-formula.R
\name{check_poly_formula}
\alias{check_poly_formula}
\title{Validate model formula as a polynomial}
\usage{
check_poly_formula(
  formula,
  x.name = "x",
  warning.text = "'formula' not an increasing polynomial: 'eq.label' is NA!"
)
}
\arguments{
\item{formula}{A model formula in \code{x.name}.}

\item{x.name}{character The name of the explanatory variable in the formula.}

\item{warning.text}{character string.}
}
\value{
A logical, TRUE if the formula describes an increasing polynomial,
  and FALSE otherwise. As a side-effect a warning is triggered when
  validation fails.
}
\description{
Analyse a model formula to determine if it describes a polynomial with
terms in order of increasing powers, and fulfils the expectations of the
algorithm used to generate the equation-label.
}
\details{
This validation check could fail to validate some valid formulas as
  it is difficult to test, or even list all possible variations of valid
  formulas. Consequently, this function triggers a warning in case of
  failure, not an error. Furthermore, the statistics only fail to build the
  correct equation label, but in most cases other output is still usable with
  models that are not strictly polynomials.

  Model formulas with and without an intercept term are accepted as valid, as
  \code{+0}, \code{-1} and \code{+1} are accepted. If a single power term is
  included, it is taken as a transformation and any power is accepted. If two
  or more terms are powers, they are expected in increasing order with no
  missing intermediate terms. If \code{poly()} is used in the model formula,
  a single term is expected.

  This function checks that all power terms defined using \code{^} are
  protected with "as is" \code{I()}, as otherwise they are not powers but
  instead part of the formula specification. It also checks that an argument
  is passed to parameter \code{raw} of function \code{poly()} if present.

  If the warning text is \code{NULL} or \code{character(0)} no warning is
  issued. The caller always receives a length-1 logical as return value.
}
\examples{
check_poly_formula(y ~ 1)
check_poly_formula(y ~ x)
check_poly_formula(y ~ x^3)
check_poly_formula(y ~ x + 0)
check_poly_formula(y ~ x - 1)
check_poly_formula(y ~ x + 1)
check_poly_formula(y ~ x + I(x^2))
check_poly_formula(y ~ 1 + x + I(x^2))
check_poly_formula(y ~ I(x^2) + x)
check_poly_formula(y ~ x + I(x^2) + I(x^3))
check_poly_formula(y ~ I(x) + I(x^2) + I(x^3))
check_poly_formula(y ~ I(x^2) + I(x^3))
check_poly_formula(y ~ I(x^2) + I(x^4))
check_poly_formula(y ~ x + I(x^3) + I(x^2))

check_poly_formula(y ~ poly(x, 2, raw = TRUE)) # use for label
check_poly_formula(y ~ poly(x, 2)) # orthogonal polynomial

}
