% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggproto.R
\name{ggproto}
\alias{ggproto}
\alias{ggproto_parent}
\title{Create a new ggproto object}
\usage{
ggproto(`_class` = NULL, `_inherit` = NULL, ...)

ggproto_parent(parent, self)
}
\arguments{
\item{_class}{Class name to assign to the object. This is stored as the class
attribute of the object. This is optional: if \code{NULL} (the default),
no class name will be added to the object.}

\item{_inherit}{ggproto object to inherit from. If \code{NULL}, don't
inherit from any object.}

\item{...}{A list of named members in the ggproto object. These can be
functions that become methods of the class or regular objects.}

\item{parent, self}{Access parent class \code{parent} of object \code{self}.}
}
\description{
Construct a new object with \code{ggproto()}, test with \code{is_ggproto()},
and access parent methods/fields with \code{ggproto_parent()}.
}
\details{
ggproto implements a protype based OO system which blurs the lines between
classes and instances. It is inspired by the proto package, but it has some
important differences. Notably, it cleanly supports cross-package
inheritance, and has faster performance.

In most cases, creating a new OO system to be used by a single package is
not a good idea. However, it was the least-bad solution for ggplot2 because
it required the fewest changes to an already complex code base.
}
\section{Calling methods}{

ggproto methods can take an optional \code{self} argument: if it is present,
it is a regular method; if it's absent, it's a "static" method (i.e. it
doesn't use any fields).

Imagine you have a ggproto object \code{Adder}, which has a
method \code{addx = function(self, n) n + self$x}. Then, to call this
function, you would use \code{Adder$addx(10)} -- the \code{self} is passed
in automatically by the wrapper function. \code{self} be located anywhere
in the function signature, although customarily it comes first.
}

\section{Calling methods in a parent}{

To explicitly call a methods in a parent, use
\code{ggproto_parent(Parent, self)}.
}

\section{Working with ggproto classes}{

The ggproto objects constructed are build on top of environments, which has
some ramifications. Environments do not follow the 'copy on modify' semantics
one might be accustomed to in regular objects. Instead they have
\href{https://adv-r.hadley.nz/names-values.html#env-modify}{'modify in place'}
semantics.
}

\examples{
Adder <- ggproto("Adder",
  x = 0,
  add = function(self, n) {
    self$x <- self$x + n
    self$x
  }
 )
is_ggproto(Adder)

Adder$add(10)
Adder$add(10)

Doubler <- ggproto("Doubler", Adder,
  add = function(self, n) {
    ggproto_parent(Adder, self)$add(n * 2)
  }
)
Doubler$x
Doubler$add(10)
}
\seealso{
The \href{https://ggplot2-book.org/internals#sec-ggproto}{ggproto introduction section} of the online ggplot2 book.
}
