% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.ggmix_fit}
\alias{plot.ggmix_fit}
\alias{plotCoef}
\title{Plot Method for \code{ggmix_fit} object}
\usage{
\method{plot}{ggmix_fit}(x, ..., xvar = c("norm", "lambda", "dev"), label = FALSE, sign.lambda = 1)

plotCoef(
  beta,
  norm,
  lambda,
  df,
  dev,
  label = FALSE,
  xvar = c("norm", "lambda", "dev"),
  xlab = iname,
  ylab = "Coefficients",
  ...
)
}
\arguments{
\item{x}{a \code{ggmix_fit} object}

\item{...}{other graphical parameters passed to \code{plot}}

\item{xvar}{What is on the X-axis. "norm" plots against the L1-norm of the
coefficients, "lambda" against the log-lambda sequence, and "dev" against
the percent deviance explained.}

\item{label}{If TRUE, label the curves with variable sequence numbers.}

\item{sign.lambda}{Either plot against log(lambda) (default) or its negative
if sign.lambda=-1}

\item{beta}{fixed effects estimates}

\item{norm}{l1 norm of fixed effect estimates. if missing, (default) this
function will calculate it}

\item{lambda}{sequence of tuning parameters}

\item{df}{number of non-zero fixed + random effects}

\item{dev}{percent deviance}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}
}
\value{
A plot is produced and nothing is returned
}
\description{
Produces a coefficient profile plot of the coefficient paths for
  a fitted \code{ggmix_fit} object.
}
\details{
A coefficient profile plot is produced
}
