% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pattern.R
\name{plot_pattern}
\alias{plot_pattern}
\title{Plot the missing data pattern of an incomplete dataset}
\usage{
plot_pattern(
  data,
  vrb = "all",
  square = TRUE,
  rotate = FALSE,
  cluster = NULL,
  npat = NULL,
  caption = TRUE
)
}
\arguments{
\item{data}{An incomplete dataset of class \code{data.frame} or \code{matrix}.}

\item{vrb}{String, vector, or unquoted expression with variable name(s), default is "all".}

\item{square}{Logical indicating whether the plot tiles should be squares, defaults to squares to mimick \code{mice::md.pattern()}.}

\item{rotate}{Logical indicating whether the variable name labels should be rotated 90 degrees.}

\item{cluster}{Optional character string specifying which variable should be used for clustering (e.g., for multilevel data).}

\item{npat}{Optional numeric input specifying the number of missing data patterns to be visualized, defaults to all patterns.}

\item{caption}{Logical indicating whether the figure caption should be displayed.}
}
\value{
An object of class \link[ggplot2:ggplot]{ggplot2::ggplot}.
}
\description{
Plot the missing data pattern of an incomplete dataset
}
\examples{
plot_pattern(mice::nhanes)
}
