% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R, R/ggstance.R
\name{gf_bar}
\alias{gf_bar}
\alias{gf_counts}
\alias{gf_props}
\alias{gf_percents}
\alias{gf_countsh}
\alias{gf_colh}
\alias{gf_propsh}
\alias{gf_percentsh}
\title{Formula interface to geom_bar()}
\usage{
gf_bar(object = NULL, gformula = NULL, data = NULL, alpha, color,
  fill, group, linetype, size, width = NULL, xlab, ylab, title, subtitle,
  caption, geom = "bar", stat = "count", position = "stack",
  show.legend = NA, show.help = NULL, inherit = TRUE,
  environment = parent.frame(), ...)

gf_counts(object = NULL, gformula = NULL, data = NULL, alpha, color,
  fill, group, linetype, size, width = NULL, binwidth = NULL, xlab,
  ylab, title, subtitle, caption, geom = "bar", stat = "count",
  position = "stack", show.legend = NA, show.help = NULL,
  inherit = TRUE, environment = parent.frame(), ...)

gf_props(object = NULL, gformula = NULL, data = NULL, alpha, color,
  fill, group, linetype, size, xlab, ylab = "proportion", title,
  subtitle, caption, geom = "bar", stat = "count",
  position = "stack", show.legend = NA, show.help = NULL,
  inherit = TRUE, environment = parent.frame(), ...)

gf_percents(object = NULL, gformula = NULL, data = NULL, alpha,
  color, fill, group, linetype, size, xlab, ylab = "percent", title,
  subtitle, caption, geom = "bar", stat = "count",
  position = "stack", show.legend = NA, show.help = NULL,
  inherit = TRUE, environment = parent.frame(), ...)

gf_countsh(object = NULL, gformula = NULL, data = NULL, alpha, color,
  fill, group, linetype, size, width = NULL, binwidth = NULL, xlab,
  ylab, title, subtitle, caption, geom = "barh", stat = "counth",
  position = "stackv", show.legend = NA, show.help = NULL,
  inherit = TRUE, environment = parent.frame(), ...)

gf_colh(object = NULL, gformula = NULL, data = NULL, alpha, color,
  fill, group, linetype, size, width = NULL, binwidth = NULL, xlab,
  ylab, title, subtitle, caption, geom = "colh", stat = "identity",
  position = "stackv", show.legend = NA, show.help = NULL,
  inherit = TRUE, environment = parent.frame(), ...)

gf_propsh(object = NULL, gformula = NULL, data = NULL, alpha, color,
  fill, group, linetype, size, xlab = "proportion", ylab, title,
  subtitle, caption, geom = "barh", stat = "counth",
  position = "stackv", show.legend = NA, show.help = NULL,
  inherit = TRUE, environment = parent.frame(), ...)

gf_percentsh(object = NULL, gformula = NULL, data = NULL, alpha,
  color, fill, group, linetype, size, xlab = "percent", ylab, title,
  subtitle, caption, geom = "barh", stat = "counth",
  position = "stackv", show.legend = NA, show.help = NULL,
  inherit = TRUE, environment = parent.frame(), ...)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula, typically with shape \code{~ x}.  (\code{y ~ x} is also possible,
but typically using one of \code{\link[=gf_col]{gf_col()}}, \code{\link[=gf_props]{gf_props()}}, or \code{\link[=gf_percents]{gf_percents()}} is preferable
to using this formula shape.)
Faceting can be achieved by including \code{|} in the formula.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data.}

\item{alpha}{Opacity (0 = invisible, 1 = opaque).}

\item{color}{A color or a formula used for mapping color.}

\item{fill}{A color for filling, or a formula used for mapping fill.}

\item{group}{Used for grouping.}

\item{linetype}{A linetype (numeric or "dashed", "dotted", etc.) or a formula used
for mapping linetype.}

\item{size}{A numeric size or a formula used for mapping size.}

\item{width}{Width of the bars.}

\item{xlab}{Label for x-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{ylab}{Label for y-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{title}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{subtitle}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{caption}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{geom}{Override the default connection between \code{geom_bar()} and
\code{stat_count()}.}

\item{stat}{Override the default connection between \code{geom_bar()} and
\code{stat_count()}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{environment}{An environment in which to look for variables not found in \code{data}.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~ expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.}

\item{binwidth}{\code{geom_bar()} no longer has a binwidth argument - if
you use it you'll get an warning telling to you use
\code{\link[=geom_histogram]{geom_histogram()}} instead.}
}
\value{
a gg object
}
\description{
There are two types of bar charts: \code{geom_bar()} and \code{geom_col()}.
\code{geom_bar()} makes the height of the
bar proportional to the number of cases in each group (or if the
\code{weight} aesthetic is supplied, the sum of the weights). If you want the
heights of the bars to represent values in the data, use
\code{geom_col()} instead. \code{geom_bar()} uses \code{stat_count()} by
default: it counts the number of cases at each x position. \code{geom_col()}
uses \code{stat_identity()}: it leaves the data as is.
}
\section{Specifying plot attributes}{


Positional attributes (a.k.a, aesthetics) are specified using the formula in \code{gformula}.
Setting and mapping of additional attributes can be done through the
use of additional arguments.
Attributes can be set can be set using arguments of the form \code{attribute = value} or
mapped using arguments of the form \code{attribute = ~ expression}.

In formulas of the form \code{A | B}, \code{B} will be used to form facets using
\code{\link[=facet_wrap]{facet_wrap()}} or \code{\link[=facet_grid]{facet_grid()}}.
This provides an alternative to
\code{\link[=gf_facet_wrap]{gf_facet_wrap()}} and
\code{\link[=gf_facet_grid]{gf_facet_grid()}} that is terser and may feel more familiar to users
of \pkg{lattice}.
}

\section{Evaluation}{


Evaluation of the \pkg{ggplot2} code occurs in the environment of \code{gformula}.
This will typically do the right thing when formulas are created on the fly, but might not
be the right thing if formulas created in one environment are used to create plots
in another.
}

\examples{
gf_bar( ~ substance, data = mosaicData::HELPrct)
gf_bar( ~ substance, data = mosaicData::HELPrct, fill = ~ sex)
gf_bar( ~ substance, data = mosaicData::HELPrct, fill = ~ sex,
       position = position_dodge())
# gf_counts() is another name for gf_bar()
gf_counts( ~ substance, data = mosaicData::HELPrct, fill = ~ sex,
          position = position_dodge())
# gf_props() and gf_percents() use proportions or percentages instead of counts
gf_props( ~ substance, data = mosaicData::HELPrct, fill = ~ sex,
         position = position_dodge())
gf_percents( ~ substance, data = mosaicData::HELPrct, fill = ~ sex,
            position = position_dodge())
if (require(scales)) {
  gf_props( ~ substance, data = mosaicData::HELPrct, fill = ~ sex,
           position = position_dodge()) \%>\%
    gf_refine(scale_y_continuous(labels = scales::percent))
}
}
\seealso{
\code{\link[ggplot2:geom_bar]{ggplot2::geom_bar()}}
}
