% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_text}
\alias{gf_text}
\alias{gf_label}
\title{Formula interface to geom_text() and geom_label()}
\usage{
gf_text(object = NULL, gformula = NULL, data = NULL, label, alpha, angle,
  color, family, fontface, group, hjust, lineheight, size, vjust,
  parse = FALSE, nudge_x = 0, nudge_y = 0, check_overlap = FALSE, xlab,
  ylab, title, subtitle, caption, geom = "text", stat = "identity",
  position = "nudge", show.legend = NA, show.help = NULL,
  inherit = TRUE, environment = parent.frame(), ...)

gf_label(object = NULL, gformula = NULL, data = NULL, label, alpha, angle,
  color, family, fontface, group, hjust, lineheight, size, vjust, parse,
  nudge_x = 0, nudge_y = 0, label.padding = unit(0.25, "lines"),
  label.r = unit(0.15, "lines"), label.size = 0.25, xlab, ylab, title,
  subtitle, caption, stat = "identity", position = "nudge",
  show.legend = NA, show.help = NULL, inherit = TRUE,
  environment = parent.frame(), ...)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{y ~ x}.
Faceting can be achieved by including \code{|} in the formula.}

\item{data}{A data frame with the variables to be plotted.}

\item{label}{The text to be displayed.}

\item{alpha}{Opacity (0 = invisible, 1 = opaque).}

\item{angle}{An angle for rotating the text.}

\item{color}{A color or a formula used for mapping color.}

\item{family}{A font family.}

\item{fontface}{One of \code{"plain"}, \code{"bold"}, \code{"italic"}, or \code{"bold italic"}.}

\item{group}{Used for grouping.}

\item{hjust, vjust}{Numbers between 0 and 1 indicating how to justify
text relative the the specified location.}

\item{lineheight}{Line height.}

\item{size}{A numeric size or a formula used for mapping size.}

\item{parse}{If TRUE, the labels will be parsed into expressions and
displayed as described in ?plotmath}

\item{nudge_x}{Horizontal and vertical adjustment to nudge labels by.
Useful for offsetting text from points, particularly on discrete scales.}

\item{nudge_y}{Horizontal and vertical adjustment to nudge labels by.
Useful for offsetting text from points, particularly on discrete scales.}

\item{check_overlap}{If \code{TRUE}, text that overlaps previous text in the
same layer will not be plotted.}

\item{xlab}{Label for x-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{ylab}{Label for y-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{title}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{subtitle}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{caption}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{geom}{A character string naming the geom used to make the layer.}

\item{stat}{A character string naming the stat used to make the layer.}

\item{position}{Either a character string naming the position function used
for the layer or a position object returned from a call to a position function.}

\item{show.legend}{A logical indicating whether this layer should be included in
the legends.  \code{NA}, the default, includes layer in the legends if any
of the attributes of the layer are mapped.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{environment}{An environment in which to look for variables not found in \code{data}.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.}

\item{label.padding}{Amount of padding around label. Defaults to 0.25 lines.}

\item{label.r}{Radius of rounded corners. Defaults to 0.15 lines.}

\item{label.size}{Size of label border, in mm.}
}
\value{
a gg object
}
\description{
Scatterplots in \code{ggformula}.
}
\details{
Positional aesthetics are specified using the formula in \code{gformula}.
Setting and mapping of additional attributes can be done through the
use of additional arguments.
Attributes can be set can be set using arguments of the form \code{attribute = value} or
mapped using arguments of the form \code{attribute = ~ expression}.

In formulas of the form \code{A | B}, \code{B} will be used to form facets using
\code{\link[=facet_wrap]{facet_wrap()}} or \code{\link[=facet_grid]{facet_grid()}}.
This provides an alternative to
\code{\link[=gf_facet_wrap]{gf_facet_wrap()}} and
\code{\link[=gf_facet_grid]{gf_facet_grid()}} that is terser and may feel more familiar to users
of \pkg{lattice}.

Evaluation of the \pkg{ggplot2} code occurs in the environment of \code{gformula}.
This will typically do the right thing when formulas are created on the fly, but might not
be the right thing if formulas created in one environment are used to create plots
in another.
}
\examples{
gf_text(Sepal.Length ~ Sepal.Width, data = iris,
  label = ~Species, color = ~Species, size = 2, angle = 30)
gf_point(Sepal.Length ~ Sepal.Width, data = iris, color = ~Species) \%>\%
gf_text(Sepal.Length ~ Sepal.Width, data = iris,
  label = ~Species, color = ~Species,
  size = 2, angle = 0, hjust = 0, nudge_x  = 0.1, nudge_y = 0.1)

if (require(dplyr)) {
  iris_means <-
    iris \%>\%
    group_by(Species) \%>\%
    summarise(Sepal.Length = mean(Sepal.Length), Sepal.Width = mean(Sepal.Width))
  gf_point(Sepal.Length ~ Sepal.Width, data = iris, color = ~ Species) \%>\%
  gf_label(Sepal.Length ~ Sepal.Width, data = iris_means,
    label = ~Species, color = ~Species, size = 2, alpha = 0.7)
}
}
\seealso{
\code{\link[ggplot2:geom_text]{ggplot2::geom_text()}}
}
