% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_boxplot}
\alias{gf_boxplot}
\title{Formula interface to geom_boxplot()}
\usage{
gf_boxplot(object = NULL, gformula = NULL, data = NULL,
  geom = "boxplot", stat = "boxplot", position = "dodge",
  show.legend = NA, show.help = NULL, inherit = TRUE,
  environment = parent.frame(), xlab, ylab, title, subtitle, caption, ...)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{y ~ x}.
Faceting can be achieved by including \code{|} in the formula.}

\item{data}{A data frame with the variables to be plotted.}

\item{geom}{A character string naming the geom used to make the layer.}

\item{stat}{A character string naming the stat used to make the layer.}

\item{position}{Either a character string naming the position function used
for the layer or a position object returned from a call to a position function.}

\item{show.legend}{A logical indicating whether this layer should be included in
the legends.  \code{NA}, the default, includes layer in the legends if any
of the attributes of the layer are mapped.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{environment}{An environment in which to look for variables not found in \code{data}.}

\item{xlab}{Label for x-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{ylab}{Label for y-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{title}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{subtitle}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{caption}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.
Available attributes include
\code{alpha}, \code{color}, \code{fill}, \code{group}, \code{linetype}, \code{shape}, \code{size}, \code{weight}, \code{coef}, \code{outlier.color}, \code{outlier.fill}, \code{outlier.shape}, \code{outlier.size}, \code{outlier.stroke}, \code{outlier.alpha}, \code{notch}, \code{notchwidth}, \code{varwidth}}
}
\value{
a gg object
}
\description{
Formula interface to geom_boxplot()
}
\details{
Positional aesthetics are specified using the formula in \code{gformula}.
Setting and mapping of additional attributes can be done through the
use of additional arguments.
Attributes can be set can be set using arguments of the form \code{attribute = value} or
mapped using arguments of the form \code{attribute = ~ expression}.

In formulas of the form \code{A | B}, \code{B} will be used to form facets using
\code{\link[=facet_wrap]{facet_wrap()}} or \code{\link[=facet_grid]{facet_grid()}}.
This provides an alternative to
\code{\link[=gf_facet_wrap]{gf_facet_wrap()}} and
\code{\link[=gf_facet_grid]{gf_facet_grid()}} that is terser and may feel more familiar to users
of \pkg{lattice}.

Evaluation of the \pkg{ggplot2} code occurs in the environment of \code{gformula}.
This will typically do the right thing when formulas are created on the fly, but might not
be the right thing if formulas created in one environment are used to create plots
in another.
}
\examples{
if (require(mosaicData)) {
  gf_boxplot(age ~ substance, data = HELPrct)
  gf_boxplot(age ~ substance, data = HELPrct, varwidth = TRUE)
  gf_boxplot(age ~ substance, data = HELPrct, color = ~sex)
  gf_boxplot(age ~ substance, data = HELPrct, color = ~sex, outlier.color = "gray50")
  # longer whiskers
  gf_boxplot(age ~ substance, data = HELPrct, color = ~sex, coef = 2)
  gf_boxplot(age ~ substance, data = HELPrct, color = ~sex, position = position_dodge(width = 0.9))
}
}
\references{
McGill, R., Tukey, J. W. and Larsen, W. A. (1978) Variations of
    box plots. The American Statistician 32, 12-16.
}
\seealso{
\code{\link[ggplot2:geom_boxplot]{ggplot2::geom_boxplot()}}, \code{\link[=fivenum]{fivenum()}}, \code{\link[=df_stats]{df_stats()}}
}
