% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow-wake.R
\name{shadow_wake}
\alias{shadow_wake}
\title{Show preceding frames with gradual falloff}
\usage{
shadow_wake(wake_length, size = TRUE, alpha = TRUE, colour = NULL,
  fill = NULL, falloff = "cubic-in", wrap = TRUE,
  exclude_layer = NULL, exclude_phase = c("enter", "exit"))
}
\arguments{
\item{wake_length}{A number between 0 and 1 giving the length of the wake,
in relation to the total number of frames.}

\item{size}{Numeric indicating the size the wake should end on. If \code{NULL}
then size is not modified. Can also be a boolean with \code{TRUE} beeing equal \code{0}
and \code{FALSE} beeing equal to \code{NULL}}

\item{alpha}{as \code{size} but for alpha modification of the wake}

\item{colour, fill}{colour or fill the wake should end on. If \code{NULL} they are
not modified.}

\item{falloff}{An easing function that control how size and/or alpha should
change.}

\item{wrap}{Should the shadow wrap around, so that the first frame will get
shadows from the end of the animation.}

\item{exclude_layer}{Indexes of layers that should be excluded.}

\item{exclude_phase}{Element phases that should not get a shadow. Possible
values are \code{'enter'}, \code{'exit'}, \code{'static'}, \code{'transition'}, and \code{'raw'}. If
\code{NULL} all phases will be included. Defaults to \code{'enter'} and \code{'exit'}}
}
\description{
This shadow is meant to draw a small wake after data by showing the latest
frames up to the current. You can choose to gradually diminish the size
and/or opacity of the shadow. The length of the wake is not given in absolute
frames as that would make the animation susceptible to changes in the
framerate. Instead it is given as a proportion of the total length of the
animation.
}
\examples{
anim <- ggplot(iris, aes(Petal.Length, Sepal.Length)) +
  geom_point() +
  labs(title = "{closest_state}") +
  transition_states(Species, transition_length = 4, state_length = 1)

# `shadow_wake` can be combined with e.g. `transition_states` to show
# motion of geoms as they are in transition with respect to the selected state.
anim1 <- anim +
  shadow_wake(wake_length = 0.05)

# Different qualities can be manipulated by setting a value for it that it
# should taper off to
anim2 <- anim +
  shadow_wake(0.1, size = 10, alpha = FALSE, colour = 'grey92')

# Use `detail` in the `animate()` call to increase the number of calculated
# frames and thus make the wake smoother
\dontrun{
animate(anim2, detail = 5)
}

}
\seealso{
Other shadows: \code{\link{shadow_mark}},
  \code{\link{shadow_null}}, \code{\link{shadow_trail}}
}
\concept{shadows}
