% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify-matrix-maftools.R
\name{fortify_matrix.MAF}
\alias{fortify_matrix.MAF}
\alias{fortify_matrix.MAF_pathways}
\title{Build a Matrix for OncoPrint}
\usage{
\method{fortify_matrix}{MAF}(
  data,
  ...,
  genes = NULL,
  n_top = NULL,
  remove_empty_genes = TRUE,
  remove_empty_samples = TRUE,
  collapse_vars = TRUE,
  use_syn = TRUE,
  missing_genes = "error",
  data_arg = NULL,
  call = NULL
)

\method{fortify_matrix}{MAF_pathways}(
  data,
  ...,
  pathdb = "smgbp",
  remove_empty_pathways = TRUE,
  remove_empty_samples = TRUE,
  data_arg = NULL,
  call = NULL
)
}
\arguments{
\item{data}{A \code{\link[maftools:read.maf]{MAF}} object.}

\item{...}{These dots are for future extensions and must be empty.}

\item{genes}{An atomic character defines the genes to draw.}

\item{n_top}{A single number indicates how many top genes to be drawn.}

\item{remove_empty_genes}{A single boolean value indicats whether to drop
genes without any genomic alterations.}

\item{remove_empty_samples}{A single boolean value indicats whether to drop
samples without any genomic alterations.}

\item{collapse_vars}{A single boolean value indicating whether to collapse
multiple alterations in the same sample and gene into a single value
\code{"Multi_Hit"}. Alternatively, you can provide a single string indicates the
collapsed values.}

\item{use_syn}{A single boolean value indicates whether to include synonymous
variants when Classifies SNPs into transitions and transversions.}

\item{missing_genes}{A string, either \code{"error"} or \code{"remove"}, specifying the
action for handling missing genes.}

\item{data_arg}{The argument name for \code{data}. Developers can use it to
improve messages. Not used by the user.}

\item{call}{The execution environment where \code{data} and other arguments for
the method are collected. Developers can use it to improve messages. Not
used by the user.}

\item{pathdb}{A string of \code{"smgbp"} or \code{"sigpw"}, or a named list
of genes to define the pathways.}

\item{remove_empty_pathways}{A single boolean value indicats whether to drop
pathways without any genomic alterations.}
}
\description{
Convert \code{MAF} object to a matrix:
\itemize{
\item \code{fortify_matrix.MAF}: Extract genomic alterations for genes.
\item \code{fortify_matrix.MAF_pathways}: Extract genomic alterations for pathways.
\code{\link[=tune.MAF]{tune.MAF()}} helps convert \code{MAF} object to a \code{MAF_pathways} object.
}
}
\section{ggalign attributes}{

For \code{fortify_matrix.MAF}:
\itemize{
\item \code{gene_summary}: A data frame of gene summary informations. See
\code{maftools::getGeneSummary()} for details.
\item \code{sample_summary}: A data frame of sample summary informations. See
\code{maftools::getSampleSummary()} for details.
\item \code{sample_anno}: A data frame of sample clinical informations. See
\code{maftools::getClinicalData()} for details.
\item \code{variant_weights}: A data frame of variant weights. Each gene in a sample
is assigned a total weight of \code{1}. When multiple variants occur in the
same gene-sample pair, the weight for each variant reflects its proportion
of the total.
\item \code{n_genes}: Total number of genes.
\item \code{n_samples}: Total number of samples.
\item \code{titv}: A list of data frame with Transitions and Transversions
summary. See \code{maftools::titv()} for details.
}

The levels of \code{Variant_Classification} will be stored in \code{\link[=ggalign_lvls]{ggalign_lvls()}}.
If they do not exist, alphabetical ordering will be used.


For \code{fortify_matrix.MAF_pathways}:
\itemize{
\item \code{gene_list}: the pathway contents.
\item \code{pathway_summary}: pathway summary informations. See
\code{maftools::pathways()} for details.
\item \code{sample_summary}: sample summary informations. See
\code{maftools::getSampleSummary()} for details.
\item \code{sample_anno}: sample clinical informations. See
\code{maftools::getClinicalData()} for details.
}
}

\seealso{
Other \code{\link[=fortify_matrix]{fortify_matrix()}} methods:
\code{\link{fortify_matrix.GISTIC}()},
\code{\link{fortify_matrix.default}()},
\code{\link{fortify_matrix.list_upset}()},
\code{\link{fortify_matrix.matrix}()},
\code{\link{fortify_matrix.matrix_oncoplot}()},
\code{\link{fortify_matrix.matrix_upset}()},
\code{\link{fortify_matrix.phylo}()}
}
\concept{fortify_matrix}
