% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-magick.R
\name{raster_magick_interal}
\alias{raster_magick_interal}
\alias{.raster_magick}
\alias{.raster_magick.Layer}
\alias{.raster_magick.list}
\alias{.raster_magick.ggplot}
\alias{.raster_magick.grob}
\alias{.raster_magick.gList}
\alias{.raster_magick.ggalignRasterMagick}
\alias{.raster_magick.zeroGrob}
\alias{.raster_magick.default}
\title{Rasterize the input object}
\usage{
.raster_magick(x, ...)

\method{.raster_magick}{Layer}(x, ...)

\method{.raster_magick}{list}(x, ...)

\method{.raster_magick}{ggplot}(x, ...)

\method{.raster_magick}{grob}(x, magick = NULL, ..., res = NULL, interpolate = FALSE)

\method{.raster_magick}{gList}(x, magick = NULL, ..., res = NULL, interpolate = FALSE)

\method{.raster_magick}{ggalignRasterMagick}(x, magick = NULL, ..., res = NULL, interpolate = FALSE)

\method{.raster_magick}{zeroGrob}(x, ...)

\method{.raster_magick}{default}(x, ...)
}
\arguments{
\item{x}{An object to rasterize, can be a \code{\link[grid:grid.grob]{grob()}},
\code{\link[ggplot2:layer]{layer()}}, \code{\link[ggplot2:ggplot]{ggplot()}}, or a list of such
objects.}

\item{...}{Not used currently.}

\item{magick}{A function (purrr-style formula is accepted) that takes an
\code{\link[magick:editing]{image_read()}} object as input and returns an object
compatible with \code{\link[grDevices:as.raster]{as.raster()}}. You can use any of
the \verb{image_*()} functions from the \strong{magick} package to process the raster
image.}

\item{res}{An integer sets the desired resolution in pixels.}

\item{interpolate}{
    A logical value indicating whether to linearly interpolate the
    image (the alternative is to use nearest-neighbour interpolation,
    which gives a more blocky result).
  }
}
\value{
An object with the same class of the input.
}
\description{
An internal function designed to implement the functionality of
\code{raster_magick()}. It assumes the input arguments are valid and does not
perform any additional checks.
}
\keyword{internal}
