% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark.R
\name{mark_triangle}
\alias{mark_triangle}
\title{Link the observations and the panel with a triangle}
\usage{
mark_triangle(..., orientation = "plot", .element = NULL)
}
\arguments{
\item{...}{<\link[rlang:dyn-dots]{dyn-dots}> A list of formulas, where each side
of the formula should be an \code{integer} or \code{character} index of the original
data, or a \code{range_link()} object defining the linked observations. Use
\code{NULL} to indicate no link on that side. You can also combine these by
wrapping them into a single \code{list()}. If only the left-hand side of the
formula exists, you can input it directly. For integer indices, wrap them
with \code{\link[=I]{I()}} to use the ordering from the layout. You can also use
\code{\link[ggplot2:waiver]{waiver()}} to inherit values from the other group.}

\item{orientation}{A single string, either \code{"plot"} or \code{"observation"},
indicating the base of the triangle.}

\item{.element}{An \code{\link[=element_polygon]{element_polygon()}} object. Vectorized fields will be
recycled to match the total number of groups, or you can wrap the element
with \code{\link[=I]{I()}} to recycle to match the drawing groups.
\itemize{
\item When \code{orientation} is \code{"plot"}, the drawing groups typically correspond
to the number of observations.
\item When \code{orientation} is \code{"observation"}, the drawing groups usually match
the defined groups, but will differ if the defined group of observations
is separated and cannot be linked with a single triangle. In this case,
the number of drawing groups will be larger than the number of defined
groups.
}}
}
\description{
Link the observations and the panel with a triangle
}
