% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-circle-.R
\name{circle_layout}
\alias{circle_layout}
\alias{circle_discrete}
\alias{circle_continuous}
\title{Arrange plots in a circular layout}
\usage{
circle_layout(
  data = NULL,
  ...,
  radial = NULL,
  direction = "outward",
  limits = waiver(),
  theme = NULL
)

circle_discrete(
  data = NULL,
  ...,
  radial = NULL,
  direction = "outward",
  theme = NULL
)

circle_continuous(
  data = NULL,
  ...,
  radial = NULL,
  direction = "outward",
  limits = NULL,
  theme = NULL
)
}
\arguments{
\item{data}{Default dataset to use for the layout. If not specified, it must be supplied in each plot added to the layout:
\itemize{
\item If \code{limits} is not provided, \code{\link[=fortify_matrix]{fortify_matrix()}} will be used to get a
matrix.
\item If \code{limits} is specified, \code{\link[=fortify_data_frame]{fortify_data_frame()}} will be used to get a
data frame.
}}

\item{...}{Additional arguments passed to \code{\link[=fortify_data_frame]{fortify_data_frame()}} or
\code{\link[=fortify_matrix]{fortify_matrix()}}.}

\item{radial}{A \code{\link[ggplot2:coord_polar]{coord_radial()}} object that defines
the global parameters for \code{coord_radial} across all plots in the layout.
The parameters \code{start}, \code{end}, \code{direction}, and \code{expand} will be inherited
and applied uniformly to all plots within the layout. The parameters
\code{theta} and \code{r.axis.inside} will always be ignored and will be set to
\code{"x"} and \code{TRUE}, respectively, for all plots.}

\item{direction}{A single string of \code{"inward"} or \code{"outward"},
indicating the direction in which the plot is added.
\itemize{
\item \code{outward}: The plot is added from the inner to the outer.
\item \code{inward}: The plot is added from the outer to the inner.
}}

\item{limits}{A \code{\link[=continuous_limits]{continuous_limits()}} object specifying the left/lower
limit and the right/upper limit of the scale. Used to align the continuous
axis.}

\item{theme}{A \code{\link[ggplot2:theme]{theme()}} object used to customize various
elements of the layout, including \code{guides}, \code{title}, \code{subtitle}, \code{caption},
\code{margins}, \code{panel.border}, and \code{background}. By default, the theme will
inherit from the parent \code{layout}. It also controls the panel spacing for all
plots in the layout.}
}
\value{
A \code{CircleLayout} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

If \code{limits} is provided, a continuous variable will be required and aligned
in the direction specified (\code{circle_continuous}). Otherwise, a discrete
variable will be required and aligned (\code{circle_discrete}).
}
\examples{
set.seed(123)

small_mat <- matrix(rnorm(56), nrow = 7)
rownames(small_mat) <- paste0("row", seq_len(nrow(small_mat)))
colnames(small_mat) <- paste0("column", seq_len(ncol(small_mat)))

# circle_layout
# same for circle_discrete()
circle_layout(small_mat) +
    ggalign() +
    geom_tile(aes(y = .column_index, fill = value)) +
    scale_fill_viridis_c() +
    align_dendro(aes(color = branch), k = 3L) +
    scale_color_brewer(palette = "Dark2")

# same for circle_continuous()
circle_layout(mpg, limits = continuous_limits(c(3, 5))) +
    ggalign(mapping = aes(displ, hwy, colour = class)) +
    geom_point(size = 2) +
    ggalign(mapping = aes(displ, hwy, colour = class)) +
    geom_point(size = 2) &
    scale_color_brewer(palette = "Dark2") &
    theme_bw()

# circle_discrete()
# direction outward
circle_discrete(small_mat) +
    align_dendro(aes(color = branch), k = 3L) +
    scale_color_brewer(palette = "Dark2") +
    ggalign() +
    geom_tile(aes(y = .column_index, fill = value)) +
    scale_fill_viridis_c()

# direction inward
circle_discrete(small_mat, direction = "inward") +
    ggalign() +
    geom_tile(aes(y = .column_index, fill = value)) +
    scale_fill_viridis_c() +
    align_dendro(aes(color = branch), k = 3L) +
    scale_color_brewer(palette = "Dark2")

# circle_continuous()
circle_continuous(mpg, limits = continuous_limits(c(3, 5))) +
    ggalign(mapping = aes(displ, hwy, colour = class)) +
    geom_point(size = 2) +
    ggalign(mapping = aes(displ, hwy, colour = class)) +
    geom_point(size = 2) &
    scale_color_brewer(palette = "Dark2") &
    theme_bw()
}
