% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparisons.R
\name{obs_calculate}
\alias{obs_calculate}
\title{Calculate Observed Covariate Means and Risk}
\usage{
obs_calculate(
  outcome_name,
  compevent_name,
  time_name,
  covnames,
  comprisk,
  outcome_type,
  obs_data
)
}
\arguments{
\item{outcome_name}{Character string specifying the name of the outcome variable in \code{obs_data}.}

\item{compevent_name}{Character string specifying the name of the competing event variable in \code{obs_data}.}

\item{time_name}{Character string specifying the name of the time variable in \code{obs_data}.}

\item{covnames}{Vector of character strings specifying the names of the time-varying covariates in \code{obs_data}.}

\item{comprisk}{Logical scalar indicating the presence of a competing event.}

\item{outcome_type}{Character string specifying the "type" of the outcome. The possible "types" are: \code{"survival"}, \code{"continuous_eof"}, and \code{"binary_eof"}.}

\item{obs_data}{Data table containing the observed data.}
}
\value{
A list. Its first entry is a list of mean covariate values at each time point;
                       its second entry is a vector of the mean observed risk (for \code{"survival"}
                       outcome types) or the mean observed outcome (for \code{"continuous_eof"} and
                       \code{"binary_eof"} outcome types); for \code{"survival"} outcome types, its
                       third entry is a vector of mean observed survival.
}
\description{
This internal function calculates the mean observed values of covariates at each time point, as well as mean
observed risk.
}
\keyword{internal}
