% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_data}
\alias{get_data}
\title{Generic Get Data Function}
\usage{
get_data(url = NULL, data_trans_fn = NULL, download_data = FALSE,
  save = FALSE, save_name = NULL, return = TRUE, verbose = TRUE)
}
\arguments{
\item{url}{Character string, indicating  the url of the data to download.}

\item{data_trans_fn}{Function that takes a data.table as input and returns a single
dataframe of any type. If not specified defaults to transforming the data into a tibble.}

\item{download_data}{Logical, defaults to \code{FALSE}. If not found locally should the data be
downloaded from the specified URL?}

\item{save}{Logical, should the data be saved for reuse during the current R session. Defaults to
\code{FALSE}. If \code{TRUE} then the data is saved to the temporary directory specified by \code{\link[base]{tempdir}}.}

\item{save_name}{Character string, name to save the data under. Defaults to
\code{NULL}.}

\item{return}{Logical, should the data be returned as a dataframe.
Defaults to \code{TRUE}.}

\item{verbose}{Logical, defaults to \code{TRUE}. Should additional status and progress messages
be displayed.}
}
\value{
The data loaded from a local copy or downloaded from the given url as a dataframe, exact format specified by data_trans_fn
}
\description{
If the data is found locally in the temporary directory then this function will load the data into R.
Otherwise if \code{download_data = TRUE} then the data will be retrieved from the specified URL. Data can then be
saved  to the temporary directory by specifying \code{save = TRUE}.
}
\examples{

tb_burden <- get_data(url = "https://extranet.who.int/tme/generateCSV.asp?ds=estimates",
save_name = "TB_burden",
save = TRUE, 
download_data = TRUE)

head(tb_burden)

}
\seealso{
get_tb_burden get_data_dict
}
