% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slippy_raster.R
\name{slippy_raster}
\alias{slippy_raster}
\title{Creates a square raster centred on any lat long point, or a rectangular raster surrounding a set of lat long points from 'Mapbox', 'Mapzen' or 'Stamen' Maps using the 'slippymath' package}
\usage{
slippy_raster(
  lat,
  long,
  square_km,
  width_buffer = 1,
  image_source = "stamen",
  image_type = "watercolor",
  max_tiles = 10,
  api_key
)
}
\arguments{
\item{lat}{WGS84 latitude. Either a single point to use as the centre for a \code{square_km} sized raster, or a vector of track points}

\item{long}{WGS84 longitude. Either a single point to use as the centre for a \code{square_km} sized raster, or a vector of track points}

\item{square_km}{length of one edge the required square area, in km. Ignored if lat and long have length > 1}

\item{width_buffer}{If lat and long have length > 1, used as buffer distance around the provided points in km}

\item{image_source}{Source for the overlay image. Valid entries are "mapbox", "mapzen", "stamen".}

\item{image_type}{The type of overlay to request. "satellite", "mapbox-streets-v8", "mapbox-terrain-v2", "mapbox-traffic-v1", "terrain-rgb", "mapbox-incidents-v1" (mapbox), "dem" (mapzen) or "watercolor", "toner", "terrain" (stamen)}

\item{max_tiles}{Maximum number of tiles to be requested by 'slippymath'}

\item{api_key}{API key (required for 'mapbox')}
}
\value{
a rasterBrick image
}
\description{
Creates a square raster centred on any lat long point, or a rectangular raster surrounding a set of lat long points from 'Mapbox', 'Mapzen' or 'Stamen' Maps using the 'slippymath' package
}
\examples{
lat <- 54.4502651
long <- -3.1767946
square_km <- 1

overlay_image <- slippy_raster(lat = lat,
  long = long,
  square_km = square_km,
  image_source = "stamen",
  image_type = "watercolor",
  max_tiles = 5)
}
