% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tiles_geouy.R
\name{tiles_geouy}
\alias{tiles_geouy}
\title{This function allows to Download .jpg or .tif files from the IDEuy tiles repository, according to a 'sf' object bbox.}
\usage{
tiles_geouy(x, d = NA, format = "rgb", folder = tempdir(), urban = FALSE)
}
\arguments{
\item{x}{An 'sf' object with the same crs as the homonym parameter}

\item{d}{numeric; buffer distance for all, or for each of the elements in x; in case dist is a units object, it should be convertible to arc_degree if x has geographic coordinates, and to st_crs(x)$units otherwise. Default NA, but if x is a only one point buffer default is 100.}

\item{format}{Format of the archives to download (avaiable: "rgb" and "rgbi") Default "rgb"}

\item{folder}{Folder where are the files or be download}

\item{urban}{logical; If FALSE take orthophotos of national flight with 32cm per pixel, if TRUE take urban flight with 10cm per pixel (avaible only Montevideo at the moment)}
}
\value{
raster::stack object with th cropped tif corresponding to x bbox
}
\description{
This function allows to Download .jpg or .tif files from the IDEuy tiles repository, according to a 'sf' object bbox.
}
\examples{
\donttest{
x <- data.frame(x = 577968, y = 6147753, id = 1)
x <- sf::st_as_sf(x, coords = c("x", "y"), crs = 32721)
x_tiles <- tiles_geouy(x, urban = TRUE)
} 
}
\keyword{IDE}
\keyword{Uruguay}
\keyword{orthophotos}
