% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestkappa.R
\name{bestkappa}
\alias{bestkappa}
\title{Function for the best kappa parameter}
\usage{
bestkappa(formula, data = data, kappa = seq(0.05,1,0.05), nrepeat = 10)
}
\arguments{
\item{formula}{A formula of GOS model}

\item{data}{A data.frame of observation data}

\item{kappa}{A numeric vector of the optional percentages of observation locations
with high similarity to a prediction location.
kappa = 1 - tau, where tau is the probability parameter
in quantile operator. kappa = 0.25 means
that 25% of observations with high similarity to a prediction
location are used for modelling.}

\item{nrepeat}{A numeric value of the number of cross-validation training times.
The default value is 10.}
}
\value{
A list of the result of the best kappa and the computation process.
}
\description{
Function for determining the best kappa parameter for the optimal similarity
}
\examples{
data("zn")
# log-transformation
hist(zn$Zn)
zn$Zn <- log(zn$Zn)
hist(zn$Zn)
# remove outliers
require(SecDim)
k <- rmvoutlier(zn$Zn, coef = 2.5)
dt <- zn[-k,]
# determine the best kappa
system.time({
b1 <- bestkappa(Zn ~ Slope + Water + NDVI  + SOC + pH + Road + Mine,
                data = dt,
                kappa = c(0.01, 0.1, 1),
                nrepeat = 1)
})
b1$bestkappa
b1$plot

}
