% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geos-unary-atomic.R
\name{geos_area}
\alias{geos_area}
\alias{geos_length}
\alias{geos_x}
\alias{geos_y}
\alias{geos_z}
\alias{geos_xmin}
\alias{geos_ymin}
\alias{geos_xmax}
\alias{geos_ymax}
\alias{geos_minimum_clearance}
\alias{geos_is_empty}
\alias{geos_is_simple}
\alias{geos_is_ring}
\alias{geos_has_z}
\alias{geos_is_closed}
\alias{geos_type_id}
\alias{geos_type}
\alias{geos_precision}
\alias{geos_srid}
\alias{geos_num_coordinates}
\alias{geos_num_geometries}
\alias{geos_num_interior_rings}
\alias{geos_num_rings}
\alias{geos_dimension}
\alias{geos_coordinate_dimension}
\alias{geos_is_clockwise}
\alias{geos_hilbert_code}
\title{Extract information from a GEOS geometry}
\usage{
geos_area(geom)

geos_length(geom)

geos_x(geom)

geos_y(geom)

geos_z(geom)

geos_xmin(geom)

geos_ymin(geom)

geos_xmax(geom)

geos_ymax(geom)

geos_minimum_clearance(geom)

geos_is_empty(geom)

geos_is_simple(geom)

geos_is_ring(geom)

geos_has_z(geom)

geos_is_closed(geom)

geos_type_id(geom)

geos_type(geom)

geos_precision(geom)

geos_srid(geom)

geos_num_coordinates(geom)

geos_num_geometries(geom)

geos_num_interior_rings(geom)

geos_num_rings(geom)

geos_dimension(geom)

geos_coordinate_dimension(geom)

geos_is_clockwise(geom)

geos_hilbert_code(geom, extent = wk::wk_bbox(geom), level = 15)
}
\arguments{
\item{geom}{A \link[=as_geos_geometry]{GEOS geometry vector}}

\item{extent}{A geometry describing the extent of \code{geom} within which
Hilbert codes should be computed. Defaults to \code{\link[wk:wk_bbox]{wk::wk_bbox()}} of \code{geom}.}

\item{level}{The Hilbert level of precision (between 0 and 15).}
}
\value{
A vector of length \code{geom}
}
\description{
Note that \code{\link[=geos_x]{geos_x()}}, \code{\link[=geos_y]{geos_y()}}, and \code{\link[=geos_z]{geos_z()}} do not handle
empty points (use \code{\link[=geos_write_xy]{geos_write_xy()}} if you need to handle this case).
Similarly, the min/max functions will error on empty geometries.
}
\examples{
geos_area("POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))")
geos_length("POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))")
geos_x("POINT Z (1 2 3)")
geos_y("POINT Z (1 2 3)")
geos_z("POINT Z (1 2 3)")
geos_xmin("LINESTRING (0 1, 2 3)")
geos_ymin("LINESTRING (0 1, 2 3)")
geos_xmax("LINESTRING (0 1, 2 3)")
geos_ymax("LINESTRING (0 1, 2 3)")
geos_minimum_clearance("POLYGON ((0 0, 10 0, 10 10, 3 5, 0 10, 0 0))")

geos_is_empty(c("POINT EMPTY", "POINT (0 1)"))
geos_is_simple(c("LINESTRING (0 0, 1 1)", "LINESTRING (0 0, 1 1, 1 0, 0 1)"))
geos_is_ring(
  c(
    "LINESTRING (0 0, 1 0, 1 1, 0 1, 0 0)",
    "LINESTRING (0 0, 1 0, 1 1, 0 1)"
   )
)
geos_is_closed(
  c(
    "LINESTRING (0 0, 1 0, 1 1, 0 1, 0 0)",
    "LINESTRING (0 0, 1 0, 1 1, 0 1)"
   )
)
geos_has_z(c("POINT Z (1 2 3)", "POINT (1 2)"))

geos_type_id(c("POINT (0 0)", "LINESTRING (0 0, 1 1)"))
geos_srid(wk::as_wkb(c("SRID=1234;POINT (0 0)", "POINT (0 0)")))
geos_num_coordinates(c("POINT (0 0)", "MULTIPOINT (0 0, 1 1)"))
geos_num_geometries(c("POINT (0 0)", "MULTIPOINT (0 0, 1 1)"))
geos_num_interior_rings("POLYGON ((0 0, 1 0, 1 1, 0 1, 0 0))")
geos_dimension(c("POINT (0 0)", "LINESTRING (0 0, 1 1)"))
geos_coordinate_dimension(c("POINT (0 0)", "POINT Z (0 0 1)"))

}
