% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geos-binary-atomic.R, R/geos-unary-geometry.R
\name{geos_project}
\alias{geos_project}
\alias{geos_project_normalized}
\alias{geos_interpolate}
\alias{geos_interpolate_normalized}
\title{Linear referencing}
\usage{
geos_project(geom1, geom2)

geos_project_normalized(geom1, geom2)

geos_interpolate(geom, distance)

geos_interpolate_normalized(geom, distance_normalized)
}
\arguments{
\item{geom1}{\link[=as_geos_geometry]{GEOS geometry vectors},
recycled to a common length.}

\item{geom2}{\link[=as_geos_geometry]{GEOS geometry vectors},
recycled to a common length.}

\item{geom}{A \link[=as_geos_geometry]{GEOS geometry vector}}

\item{distance}{Distance along the linestring to interpolate}

\item{distance_normalized}{Distance along the linestring to interpolate
relative to the length of the linestring.}
}
\description{
\itemize{
\item \code{\link[=geos_project]{geos_project()}} and \code{\link[=geos_project_normalized]{geos_project_normalized()}} return
the distance of point \code{geom2} projected on \code{geom1} from the origin
of \code{geom1}, which must be a lineal geometry.
\item \code{\link[=geos_interpolate]{geos_interpolate()}} performs an
inverse operation, returning the point along \code{geom} representing
the given \code{distance} from the origin along the geometry.
\item \verb{_normalized()} variants use a distance normalized to the
\code{\link[=geos_length]{geos_length()}} of the geometry.
}
}
\examples{
geos_interpolate("LINESTRING (0 0, 1 1)", 1)
geos_interpolate_normalized("LINESTRING (0 0, 1 1)", 1)

geos_project("LINESTRING (0 0, 10 10)", "POINT (5 5)")
geos_project_normalized("LINESTRING (0 0, 10 10)", "POINT (5 5)")

}
