% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FimsUtils.R
\name{queryMetadata}
\alias{queryMetadata}
\title{fetch the FimsMetadata from the geome-db database}
\usage{
queryMetadata(expeditions = list(), query = "", names = NULL)
}
\arguments{
\item{expeditions}{list of expeditions to include in the query. The default is all expeditions}

\item{query}{FIMS Query DSL \url{http://fims.readthedocs.io/en/latest/fims/query.html} query string.
Ex. '+locality:fuzzy +country:"exact phrase"'}

\item{names}{list of column names to include in the data.frame results}
}
\description{
fetch the FimsMetadata from the geome-db database
}
\examples{
\dontrun{
df <- queryMetadata(expeditions=list("TEST", "TEST2"))
df <- queryMetadata(names=list("materialSampleID", "bcid"), query="Chordata")
df <- queryMetadata(expeditions=list("TEST"), names=list("bcid"), query="+yearCollected:2008")
}
}

