% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf_geojson.R
\name{sf_geojson}
\alias{sf_geojson}
\title{sf to GeoJSON}
\usage{
sf_geojson(
  sf,
  atomise = FALSE,
  simplify = TRUE,
  digits = NULL,
  factors_as_string = TRUE
)
}
\arguments{
\item{sf}{simple feature object}

\item{atomise}{logical indicating if the sf object should be converted into a vector
of GeoJSON objects}

\item{simplify}{logical indicating if sf objects without property columns should simplify
(\code{TRUE}) into a vector of GeoJSON, or return a Featurecollection with
empty property fields (\code{FALSE}). If \code{atomise} is TRUE this argument is ignored.}

\item{digits}{integer specifying the number of decimal places to round numerics.
numeric values are coorced using \code{as.integer}, which may round-down the value you supply.
Default is \code{NULL} - no rounding}

\item{factors_as_string}{logical indicating if factors should be treated as strings. Defaults to TRUE.}
}
\value{
vector of GeoJSON
}
\description{
Converts `sf` objects to GeoJSON
}
\examples{
\dontrun{
library(sf)
sf <- sf::st_sf(geometry = sf::st_sfc(list(sf::st_point(c(0,0)), sf::st_point(c(1,1)))))
sf$id <- 1:2
sf_geojson(sf)
sf_geojson(sf, atomise = T)

ls <- st_linestring(rbind(c(0,0),c(1,1),c(2,1)))
mls <- st_multilinestring(list(rbind(c(2,2),c(1,3)), rbind(c(0,0),c(1,1),c(2,1))))
sfc <- st_sfc(ls,mls)
sf <- st_sf(sfc)
sf_geojson( sf )
sf_geojson( sf, simplify = FALSE )

}

}
