% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_evaluation.R
\name{calcNegentropyI}
\alias{calcNegentropyI}
\title{Negentropy Increment index}
\usage{
calcNegentropyI(data, belongmatrix, centers)
}
\arguments{
\item{data}{The original dataframe used for the clustering (n*p)}

\item{belongmatrix}{A membership matrix (n*k)}

\item{centers}{The centres of the clusters}
}
\value{
A float: the Negentropy Increment index
}
\description{
Calculate the Negentropy Increment index of clustering quality.
}
\details{
The Negentropy Increment index \insertCite{da2020incremental}{geocmeans} is based on the assumption that a normally shaped cluster is more
desirable. It uses the difference between the average negentropy
of all the clusters in the partition, and that of the  whole partition.
A smaller value indicates a better partition. The formula is:

\deqn{NI=\frac{1}{2} \sum_{j=1}^{k} p_{i} \ln \left|{\boldsymbol{\Sigma}}_{j}\right|-\frac{1}{2} \ln \left|\boldsymbol{\Sigma}_{d a t a}\right|-\sum_{j=1}^{k} p_{j} \ln p_{j}}

with  a cluster, \emph{|.|} the determinant of a matrix,
\itemize{
 \item \emph{j} a cluster
 \item \emph{|.|} the determinant of a matrix
 \item \eqn{\left|{\boldsymbol{\Sigma}}_{j}\right|} the covariance matrix of the dataset weighted by the membership values to cluster \emph{j}
 \item \eqn{\left|\boldsymbol{\Sigma}_{d a t a}\right|} the covariance matrix of the dataset
 \item \eqn{p_{j}} the sum of the membership values to cluster \emph{j} divided by the number of observations.
}
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- LyonIris@data[AnalysisFields]
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
calcNegentropyI(result$Data, result$Belongings, result$Centers)
}
\references{
\insertAllCited{}
}
