% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_weighted_surf.R
\name{get_weighted_surf}
\alias{get_weighted_surf}
\title{Generate average weighted surfaces}
\usage{
get_weighted_surf(
  obs_dens,
  cf_dens,
  mediation = FALSE,
  cate = FALSE,
  obs_med_log_sum_dens,
  cf_med_log_sum_dens,
  treatment_data,
  smoothed_outcome,
  lag,
  entire_window,
  time_after,
  truncation_level = truncation_level
)
}
\arguments{
\item{obs_dens}{observed density}

\item{cf_dens}{counterfactual density}

\item{mediation}{whether to perform causal mediation analysis. By default, FALSE.}

\item{cate}{whether to perform the heterogeneity analysis. By default, FALSE.}

\item{obs_med_log_sum_dens}{sum of log densities of mediators for the observed (if `mediation = TRUE`)}

\item{cf_med_log_sum_dens}{sum of log densities of mediators for counterfactual (if `mediation = TRUE`)}

\item{treatment_data}{column of a hyperframe that summarizes treatment data. In the form of `hyperframe$column`.}

\item{smoothed_outcome}{column of a hyperframe that summarizes the smoothed outcome data}

\item{lag}{integer that specifies lags to calculate causal estimates}

\item{entire_window}{owin object (the entire region of interest)}

\item{time_after}{whether to include one unit time difference between treatment and outcome}

\item{truncation_level}{the level at which the weights are truncated (see `get_estimates()`)}
}
\value{
list of an average weighted surface (`avarage_surf`, an `im` object),
a Hajek average weighted surface (`average_weighted_surf_haj`, an `im` object),
weights, and smoothed outcomes
}
\description{
A function that returns averaged weighted surfaces (both IPW and Hajek) along with weights
}
\details{
`get_weighted_surf()` is an internal function to `get_estimates()` function.
If `time_after` is TRUE, then this function uses treatment data and weights from lag to nrow(data)-1, and
outcome data from lag+1 to nrow(data).
}
