% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odds_ratio_function.R
\name{dom.or.function}
\alias{dom.or.function}
\title{Dominant Model Function}
\usage{
dom.or.function(like, Case.Rate, P_AA, P_AB, P_BB, True.Model, risk_allele)
}
\arguments{
\item{like}{Expected log likelihood}

\item{Case.Rate}{proportion of cases in the sample (cases/(cases + controls)).}

\item{P_AA}{Probability the allele is homozygous for the major allele}

\item{P_AB}{Probability the allele is heterozygous}

\item{P_BB}{Probability the allele is homozygous for the minor allele}

\item{True.Model}{A vector object specifying the true underlying genetic model(s): 'Dominant', 'Additive', or 'Recessive'}

\item{risk_allele}{Logical: If OR > 1, the allele is classified as a "risk allele"}
}
\value{
: The odds ratios and their corresponding genetic model(s)
}
\description{
Operates within odds_ratio_function to calculate odds ratios for a Test.Model of "Dominant"
}
\examples{
dom.or.function(like=-0.57162, Case.Rate=0.3, P_AA=0.5625, P_AB=0.375, 
 P_BB=0.0625, True.Model="Dominant", risk_allele=TRUE)

}
