% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_outcome_envir_interaction_mle_function.R
\name{calc.like.linear.log.envir.interaction}
\alias{calc.like.linear.log.envir.interaction}
\title{Function to calculate the standard deviation of y given x for linear models with logistic environment interaction}
\usage{
calc.like.linear.log.envir.interaction(
  beta_hat,
  MAF,
  P_e,
  ES_G,
  ES_E,
  ES_GE,
  sd_y_x_truth,
  sd_y_x_model,
  Test.Model,
  True.Model,
  reduced = F
)
}
\arguments{
\item{beta_hat}{Effect sizes from MLE}

\item{MAF}{Minor allele Frequency}

\item{P_e}{Population prevalence of logistic environmental factor}

\item{ES_G}{Genetic Effect size}

\item{ES_E}{Environment Effect size}

\item{ES_GE}{Environment x Genetic interaction Effect size}

\item{sd_y_x_truth}{Standard deviation of y for the true model}

\item{sd_y_x_model}{Standard deviation of y for the test model}

\item{Test.Model}{Test model}

\item{True.Model}{True model}

\item{reduced}{logical, indicates whether the X matrix will be used for a reduced model}
}
\value{
The standard deviation of y given x for linear models with logistic environment interaction
}
\description{
Returns the standard deviation of y given x for linear models with logistic environment interaction
}
\examples{
beta_hat = linear.mles.log.envir.interaction(MAF = 0.1, P_e = 0.2, 
	ES_G = 1.2, ES_E = 1.3, ES_GE = 2, 
	Test.Model = "Dominant", True.Model = "Additive")
calc.like.linear.log.envir.interaction(beta_hat = beta_hat,
	MAF = 0.1, P_e = 0.2, ES_G = 1.2, ES_E = 1.3,
	ES_GE = 2, sd_y_x_truth = 9.947945, sd_y_x_model = 9.949468, 
	True.Model = "Additive", Test.Model="Dominant")

}
