% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_CO.R
\name{count_CO}
\alias{count_CO}
\title{Internal function to remove search and remove columns based on names}
\usage{
count_CO(data, naive = FALSE)
}
\arguments{
\item{data}{genotype data read in with read_in_sequenom_data}

\item{naive}{this takes 2 values: 1) FALSE (default) will count
COs distributed by marker distance, and 2) TRUE returns will count
COs without regard to marker distance (i.e., at the final
non-missing data point in a string of missing genotypes)}
}
\value{
genotypeR object with counted crossovers
}
\description{
\code{count_CO} counts crossovers from binary coded genotypes in
a genotypeR object. This function assigns crossovers to
the counted_crossovers slot in a genotypeR object.
}
\examples{

data(genotypes_data)
data(markers)
## genotype table
marker_names <- make_marker_names(markers)
GT_table <- Ref_Alt_Table(marker_names)
## remove those markers that did not work
genotypes_data_filtered <- genotypes_data[,c(1, 2, grep("TRUE",
colnames(genotypes_data)\%in\%GT_table$marker_names))]

warnings_out2NA <- initialize_genotypeR_data(seq_data = genotypes_data_filtered,
genotype_table = GT_table, output = "warnings2NA")
binary_coding_genotypes <- binary_coding(warnings_out2NA, genotype_table = GT_table)
chr2 <- subsetChromosome(binary_coding_genotypes, chromosome="chr2")
count_CO <- count_CO(chr2)


}
\keyword{Count}
\keyword{Crossovers}
\keyword{a}
\keyword{genotypeR}
\keyword{object}
\keyword{of}
