% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_plot.R
\name{map_plot}
\alias{map_plot}
\title{Plot LTR z-scores on map}
\usage{
map_plot(data)
}
\arguments{
\item{data}{The output from the \code{genogeo} function}
}
\value{
A map with population z-scores at their geographic origin
}
\description{
Plots the results from LRT on a map based on lat/lon info in the database.
If no location is found in the data (e.g. using \code{simulte_pops}) nothing is plotted.
}
\examples{
df_ <- simulate_pops(pop_n = 4, aims_n = 50)
df_db <- pops_to_DB(df_)
profile <- random_AIMs_profile(df_db, keep_pop = TRUE)
profile$pop[1] # The true population
result <- genogeo(profile[,c("locus","x0")], df = df_db, min_n = 0) 
result$lon <- runif(n = 4, min = -125, max = 125)
result$lat <- runif(n = 4, min = -50, max = 80)
\dontrun{map_plot(result)}
}
\author{
Torben Tvedebrink, \email{tvede@math.aau.dk}
}
