% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genesys.R
\name{get_accessions}
\alias{get_accessions}
\title{Fetch accession passport data}
\usage{
get_accessions(
  filters = list(),
  page = 0,
  size = 1000,
  fields = NULL,
  exclude = NULL,
  selector = NULL,
  at.least = NULL
)
}
\arguments{
\item{filters}{an R \code{structure} with Genesys filters}

\item{page}{the page index (0-based)}

\item{size}{number of records to load per page (page size)}

\item{fields}{list of fields to fetch from Genesys}

\item{exclude}{list of field prefixes to exclude from the Genesys response}

\item{selector}{NULL or a function to "select" variables of interest}

\item{at.least}{stop fetching when at.least records are received from Genesys}
}
\value{
Paged data structure
}
\description{
Fetch accession passport data
}
\examples{
\dontrun{
  # Retrieve all accession data by country of origin (Slovenia, Ivory Coast)
  accessions <- genesysr::get_accessions(list(countryOfOrigin = list(code3 = c('SVN', 'CIV'))))

  # Fetch Musa, but only geographic data and accessionNumber
  musa <- genesysr::get_accessions(list(taxonomy = list(genus = c('Musa'))),
    fields = c("accessionNumber", "geo"))

  # Apply selector function
  accessions <- get_accessions(mcpd_filter(ORIGCTY = c('DEU', 'SVN')),
    selector = function(x) {
      list(id = x$id, acceNumb = x$accessionNumber, instCode = x$instituteCode)
    }, at.least = 100)
}

}
\seealso{
\code{\link{mcpd_filter}}
}
