% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genORA.R
\name{genORA}
\alias{genORA}
\title{Gene Over-Representation enrichment Analysis (ORA method)}
\usage{
genORA(
  id,
  geneset,
  group_list = NULL,
  padj_method = "BH",
  p_cutoff = 0.05,
  q_cutoff = 0.15,
  min_gset_size = 10,
  max_gset_size = 500,
  universe
)
}
\arguments{
\item{id}{A vector of gene id which can be entrezid, ensembl, symbol or uniprot.}

\item{geneset}{Gene set is a two-column data.frame with term id and gene id.
Please use package `geneset` to select available gene set or make new one.}

\item{group_list}{A list of gene group information, default is NULL.}

\item{padj_method}{One of "BH", "BY", "bonferroni","fdr","hochberg",
"holm", "hommel", "none"}

\item{p_cutoff}{Numeric of cutoff for both unadjusted and adjusted pvalue, default is 0.05.}

\item{q_cutoff}{Numeric of cutoff for qvalue, default is 0.15.}

\item{min_gset_size}{Numeric of minimal size of each geneset for analyzing,
default is 10.}

\item{max_gset_size}{Numeric of maximal size of each geneset for analyzing,
default is 500.}

\item{universe}{Character of background genes. If missing, all genes in
geneset will be used as background.}
}
\value{
A `data.frame`.
}
\description{
Gene Over-Representation enrichment Analysis (ORA method)
}
\examples{
\dontrun{
# only gene ids
data(geneList, package = "genekitr")
id <- names(geneList)[abs(geneList) > 1]
gs <- geneset::getGO(org = "human",ont = "mf")
ora <- genORA(id, geneset = gs)

# gene id with groups
id <- c(head(names(geneList), 100), tail(names(geneList), 100))
group <- list(
  group1 = c(rep("up", 100), rep("down", 100)),
  group2 = c(rep("A", 130), rep("B", 70))
)
gora <- genORA(id, geneset = gs, group_list = group)

}
}
